//--------------------------------------------------------------------------
/*! \file prev_post_spike_time_in_post_learn/test.cc

\brief Main test code that is part of the feature testing
suite of minimal models with known analytic outcomes that are used for continuous integration testing.
*/
//--------------------------------------------------------------------------
// Standard C includes
#include <cmath>

// Google test includes
#include "gtest/gtest.h"

// Autogenerated simulation code includess
#include "prev_post_spike_time_in_post_learn_CODE/definitions.h"

// **NOTE** base-class for simulation tests must be
// included after auto-generated globals are includes
#include "../../utils/simulation_test.h"

// Combine neuron and synapse policies together to build variable-testing fixture
class SimTest : public SimulationTest
{
public:
    void Simulate()
    {
        while(t < 200.0f) {
            StepGeNN();

            // Ignore first timestep as no presynaptic events will be processed so wsyn is in it's initial state
            if(t > DT) {
                // Loop through neurons
                for(unsigned int i = 0; i < 10; i++) {
                    // Calculate time of spikes we SHOULD be reading
                    // **NOTE** we delay by 11 timesteps because:
                    // 1) delay = 20
                    // 2) PREVIOUS spike occurred 10 timesteps before
                    // 3) t is incremented one timestep at the end of StepGeNN
                    const float delayedLastSpikeTime = (scalar)i + 11.0f + (10.0f * std::floor((t - 22.0f - (scalar)i) / 10.0f));

                    // If, theoretically, spike would have arrived before delay it's impossible so time should be a very large negative number
                    if(delayedLastSpikeTime < 21.0f) {
                        ASSERT_LT(wsyn[i], -1.0E6);
                    }
                    else {
                        ASSERT_FLOAT_EQ(wsyn[i], delayedLastSpikeTime);
                    }
                }
            }
        }
    }
};

TEST_F(SimTest, PrevPostSpikeTimeInPostLearn)
{
    Simulate();
}
