//--------------------------------------------------------------------------
/*! \file pre_vars_in_sim_code_event_sparse_inv/test.cc

\brief Main test code that is part of the feature testing
suite of minimal models with known analytic outcomes that are used for continuous integration testing.
*/
//--------------------------------------------------------------------------
// Standard C includes
#include <cmath>

// Google test includes
#include "gtest/gtest.h"

// Autogenerated simulation code includess
#include "pre_vars_in_sim_code_event_ragged_inv_CODE/definitions.h"

// **NOTE** base-class for simulation tests must be
// included after auto-generated globals are includes
#include "../../utils/simulation_test_vars.h"
#include "../../utils/simulation_neuron_policy_pre_var.h"
#include "../../utils/simulation_synapse_policy_ragged.h"

// Combine neuron and synapse policies together to build variable-testing fixture
typedef SimulationTestVars<SimulationNeuronPolicyPreVar, SimulationSynapsePolicyRagged> SimTest;

TEST_F(SimTest, PreVarsInSimCodeEventRaggedInv)
{
  float err = Simulate(
    [](unsigned int, unsigned int d, unsigned int j, float t, float &newX)
    {
        if ((t > d*DT+0.1001) && (std::fmod(t-2*DT-d*DT+5e-5+10*j,(float) (2*(d+1))) < 1e-4))
        {
            newX = t-2*DT-d*DT+10*j;
            return true;
        }
        else
        {
          return false;
        }
    });

  // Check total error is less than some tolerance
  EXPECT_LT(err, 1e-3);
}
