//--------------------------------------------------------------------------
/*! \file post_vars_in_sim_code_ragged/test.cc

\brief Main test code that is part of the feature testing
suite of minimal models with known analytic outcomes that are used for continuous integration testing.
*/
//--------------------------------------------------------------------------
// Standard C includes
#include <cmath>

// Google test includes
#include "gtest/gtest.h"

// Autogenerated simulation code includess
#include "post_vars_in_sim_code_ragged_CODE/definitions.h"

// **NOTE** base-class for simulation tests must be
// included after auto-generated globals are includes
#include "../../utils/simulation_test_vars.h"
#include "../../utils/simulation_neuron_policy_pre_post_var.h"
#include "../../utils/simulation_synapse_policy_ragged.h"

// Combine neuron and synapse policies together to build variable-testing fixture
typedef SimulationTestVars<SimulationNeuronPolicyPrePostVar, SimulationSynapsePolicyRagged> SimTest;

TEST_F(SimTest, PostVarsInSimCodeRagged)
{
    float err = Simulate(
        [](unsigned int, unsigned int d, unsigned int j, float t, float &newX)
        {
            if ((t > 1.1001) && (std::fmod(t-DT-(d+1)*DT+5e-5,1.0f) < 1e-4)) {
                newX = t-2*DT+10*((j+1)%10);
                return true;
            }
            else {
                return false;
            }
        });

    // Check total error is less than some tolerance
    EXPECT_LT(err, 3e-3);
}
