# ReadMe Summary

This ReadMe describes the data and its columns.

The dataset contains two files, "behavior\_data.csv" and "randomization\_parameter\_estimates.csv". The former file includes the infestation, lizard behavior, and lizard trait data used in Payne et al., *A field experiment reveals reciprocal effects of host personality and parasitism in wild lizards* (Behavioral Ecology). The latter file contains the model parameter estimates produced by the randomization procedure described in the aforementioned manuscript (described briefly below).

# Description of columns in behavior\_data.csv

* Lizard: the unique individual to which the focal observation (the current row) refers.
* year: the calendar year of the focal observation
* date: date in MM/DD/YYYY on which the current behavioral trial was performed
* Aggression: the lizard's aggression score. Ranked on a 1-11 scale.
    * This scale is described in "Godfrey et al. 2012. Lovers and fighters in sleepy lizard land: where do aggressive males fit
        in a social network? Animal Behavior." See Table 1.
* Boldness: the lizard's banana boldness score, on a 1-7 rank. This score reflected a lizard's response to a banana (a preferred food item) in a perceived situation of risk. See Payne et al. manuscript (mentioned above) for more details.
* sex: lizard sex. 0 is Female and 1 is Male. NA individuals had indeterminate sex.
* avgmass: the lizard's average mass for a given year (thus, for a given lizard, average mass will be the same for all observations within a single year). Provided in grams. NA value indicates no mass was recorded (happened for one lizard).
* trialnum: the trial number within season of the behavioral observation. Lizards typically received aggression and boldness assays three times per season. This trial number refers to these within season trials (a lizard's first, second, third, etc. trial within season).
* date\_infected: the date on which infestation treatment lizards were infested. Only present so that the reader can confirm that all infestation treatments occurred on a lizard's first behavioral trial of a season. NA value indicates that a lizard was part of the "no\_treatment" experimental infestation group (i.e., not experimentally infected and not used as a control; control lizards experienced the same treatment as the infected lizards, except ticks were not added to the control lizards).
* ticksAdded: the number of *Bothriocroton hydrosauri* that were added to each infestation lizard during the infestation treatment. Note that each lizard received larvae from a distinct genetic line (i.e., a different mother). NA value indicates that ticks were not experimentally added to a lizard (treatment will be "no\_treatment" or "no\_infestation" for such rows).
* ticksOnLizard: the number of B. hydrosauri larvae that successfully attached to a lizard during the infestation treatment. NA value indicates that ticks were not experimentally added to a lizard (treatment will be "no\_treatment" or "no\_infestation" for such rows).
* Treatment: a lizard's infestation treatment. One of: "no\_treatment," "no\_infestation," and "infestation."
    * "no\_treatment" lizards experienced no manipulation of any kind.
    * "no\_infestation" lizards experienced the same treatment as infestation lizards, except the no\_infestation lizards did not receive any ticks.
    * "infestation" lizards received the larvae addition treatment.
    * Note that these categorical descriptors were constant within a lizard throughout a given season. For example, lizard 2408 was an infestation lizard in 2016. This lizard (like all infestation lizards) experienced it's first behavioral assay and the infestation treatment on the same day, but the infestation treatment occurred AFTER the behavioral assay. Thus, though 2408's first behavioral observation in 2016 (September 22, 2016) has a treatment listed as "infestation," 2408 had not actually experienced the infestation treatment at the time of this first behavioral assay.
* avgbothNymph\_Larva: this column records accumulated average (larvae + nymph) tick counts. Throughout the season, we counted lizards' ticks roughly every two weeks, noting the number of larval, nymph, and adult ticks. To derive the accumulated tick average metric, we averaged a lizard's tick counts from these bi-weekly counts up to (inclusive) the current trial. However, note that we used the sum of a lizard's larvae + nymphs within a count observation. Thus, if a lizard had two tick counts before its first behavioral trial and one tick count on the day of the trial, the larvae + nymph tick counts from each of these observations would be averaged. For trial 2, tick counts from the start of the season through trial 2's date would be averaged, and so on for trial 3. NA value indicates that ticks were never counted for a lizard (happened once for a lizard that was not an adult and excluded from the study).
    * For example, if a lizard had the following tick counts (larvae/nymph/adult) at four different counting dates: 10/1/2, 5/0/2, 1/1/0, and 10/2/0.
    * If trial 1 occurred the same day as the lizard's second tick count, and trial 2 occurred the same day as the lizard's fourth tick count, then avgbothNymph\_Larva at trial 1 and 2 would be:
        * trial 1 would be: [(10+1) + (5+0)]/2
        * trial 2 would be: [(10+1) + (5+0) + (1+1) + (10+2)]/4
* avgtotal: this column records accumulated average tick counts, as described above, but for all tick stages (larvae + nymph + adult). NA value indicates that ticks were never counted for a lizard (happened once for a lizard that was not an adult and excluded from the study).
    * Using the same data as the example above, the avgtotal value at trial 1 and 2 would be:
        * trial 1 would be: [(10+1+2) + (5+0+2)]/2
        * avgtotal for trial 2 would be: [(10+1+2) + (5+0+2) + (1+1+0) + (10+2+0)]/4

Note: For the models analyzing the relationship between pre-infestation behavior and infestation success, note that the six observations for lizard 40044 were not used. In 2017, this lizard had an outlier pre-infestation tick count (149, versus all other lizards had 20 or fewer). To be conservative, we did not use the data from this lizard for either 2016 or 2017. However, the observations from this lizard *were* used in the models that assessed the effect of ticks on lizard behavior.

# Description of columns in randomization\_parameter\_estimates.csv

In the manuscript referenced earlier, the authors predicted the success of an experimental infestation treatment with the host animal's behavior prior to treatment (as well as a few other predictors). Because the infestation treatment used a limited number of animals, a randomization was conducted in which the observed treatment success was randomized with respect to the predictors. Ten thousand randomized datasets were generated, and for each one, a model was run evaluating the relationship between the predictors and the (now randomized) infestation success. For each of these 10,000 models, the parameter effect estimates were extracted and saved into the "randomization\_parameter\_estimates.csv" file.

* Intercept: the model intercept
* year: the parameter effect for year, which was treated as a factor (rather than linear) with default set to 2016
* sex: the parameter effect for sex, which was treated as a factor with default set to female
* avgmass\_z: the parameter effect for a lizard's average mass in a year
* Aggression\_z: the parameter effect for aggression, which was standardized (subtract mean and then divide by standard deviation) prior to use in models
* Boldness\_z: the parameter effect for boldness, which was standardized (subtract mean and then divide by standard deviation) prior to use in models
* Aggression\_by\_Boldness\_z: the parameter effect for the interaction between aggression and boldness