# The MIT License (MIT) # Copyright (c) 2014-2017 University of Bristol
#
#  Permission is hereby granted, free of charge, to any person obtaining a copy
#  of this software and associated documentation files (the "Software"), to deal
#  in the Software without restriction, including without limitation the rights
#  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
#  copies of the Software, and to permit persons to whom the Software is
#  furnished to do so, subject to the following conditions:
#
#  The above copyright notice and this permission notice shall be included in all
#  copies or substantial portions of the Software.
#
#  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
#  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
#  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
#  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
#  DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
#  OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE
#  OR OTHER DEALINGS IN THE SOFTWARE.

import logging
import sys
import os

sys.path.append(os.path.dirname(os.path.dirname(os.path.abspath(__file__))))
path = os.path.abspath(os.path.join(os.path.dirname(__file__), 'hyperstream_core'))
sys.path.append(path)


if __name__ == '__main__':
    from hyperstream import HyperStream
    from hyperstream.online_engine import OnlineEngine
    from hyperstream.utils.hyperstream_logger import MON, SenMLFormatter

    # noinspection PyTypeChecker
    mqtt_logger = dict(host='127.0.0.1', port=1883, loglevel=MON, topic='SPHERE/MON/SHG/ML', qos=1,
                       formatter=SenMLFormatter())

    hyperstream = HyperStream(loglevel=logging.INFO, file_logger=False, console_logger=True, mqtt_logger=mqtt_logger)
    online_engine = OnlineEngine(hyperstream)
    online_engine.execute()
