# Downloads

<!--
 Licensed to the Hipparchus project under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The Hipparchus project licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

      https://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->
## Development Library version

The development version of the Hipparchus library is always available to
download from our version control system. We use [Git](http://git-scm.com/)
as our SCM. The anonymous read access to our Git repository  allows users who
need the latest features and the latest bug fixes to get them even before an
official release.

The Git repository can be cloned using the following command, which can
be easily adapted if you are using one of the numerous Git graphical
user interface available or if Git is supported by your integrated
development environment:

    git clone https://github.com/Hipparchus-Math/hipparchus.git

## Released Library versions

Hipparchus releases are provided in source and binary distributions via the links below.  Source packages are the most complete, since the other packages (binary jars, javadoc jars, source jars, web content) are created from these sources.

Hipparchus is also available in maven central repository, with groupID org.hipparchus and artifactIds hipparchus-core,
hipparchus-clustering, hipparchus-fft, hipparchus-fitting, hipparchus-filtering, hipparchus-geometry, hipparchus-ode, hipparchus-optim and hipparchus-stat.
There is also a hipparchus-migration artifact to help migrating from Apache Commons Math.
Maven's internal mechanism will automatically download any internal dependencies among the artifacts.  Signatures may be verified using the Hipparchus [KEYS](http://www.hipparchus.org/KEYS).

---

|     package       | link                                                              | hash | signature |
|-------------------|-------------------------------------------------------------------|------|-----------|
|  source (zip)     | [hipparchus-3.0-src.zip](downloads/hipparchus-3.0-src.zip)         | [md5](downloads/hipparchus-3.0-src.zip.md5)| [sig](downloads/hipparchus-3.0-src.zip.asc)|
|  source (tar.bz2) | [hipparchus-3.0-src.tar.bz2](downloads/hipparchus-3.0-src.tar.bz2) | [md5](downloads/hipparchus-3.0-src.tar.bz2.md5) | [sig](downloads/hipparchus-3.0-src.tar.bz2.asc)|
|  binary (zip)     | [hipparchus-3.0-bin.zip](downloads/hipparchus-3.0-bin.zip)         | [md5](downloads/hipparchus-3.0-bin.zip.md5) | [sig](downloads/hipparchus-3.0-bin.zip.asc)|
|  binary (tar.bz2) | [hipparchus-3.0-bin.tar.bz2](downloads/hipparchus-3.0-bin.tar.bz2) | [md5](downloads/hipparchus-3.0-bin.tar.bz2.md5) | [sig](downloads/hipparchus-3.0-bin.tar.bz2.asc)
version 3.0 downloads (release date: 2023-10-08)

---

|     package       |                                  link                                                     | hash | signature |
|-------------------|-------------------------------------------------------------------------------------------|------|-----------|
|  source (zip)     | [hipparchus-2.3-src.zip](downloads/hipparchus-2.3-src.zip) | [md5](downloads/hipparchus-2.3-src.zip.md5)| [sig](downloads/hipparchus-2.3-src.zip.asc)|
|  source (tar.bz2) | [hipparchus-2.3-src.tar.bz2](downloads/hipparchus-2.3-src.tar.bz2) | [md5](downloads/hipparchus-2.3-src.tar.bz2.md5) | [sig](downloads/hipparchus-2.3-src.tar.bz2.asc)|
|  binary (zip)     | [hipparchus-2.3-bin.zip](downloads/hipparchus-2.3-bin.zip)| [md5](downloads/hipparchus-2.3-bin.zip.md5) | [sig](downloads/hipparchus-2.3-bin.zip.asc)|
|  binary (tar.bz2) | [hipparchus-2.3-bin.tar.bz2](downloads/hipparchus-2.3-bin.tar.bz2) | [md5](downloads/hipparchus-2.3-bin.tar.bz2.md5) | [sig](downloads/hipparchus-2.3-bin.tar.bz2.asc)
version 2.3 downloads (release date: 2022-10-05)

---

|     package       |                                  link                                                     | hash | signature |
|-------------------|-------------------------------------------------------------------------------------------|------|-----------|
|  source (zip)     | [hipparchus-2.2-src.zip](downloads/hipparchus-2.2-src.zip) | [md5](downloads/hipparchus-2.2-src.zip.md5)| [sig](downloads/hipparchus-2.2-src.zip.asc)|
|  source (tar.bz2) | [hipparchus-2.2-src.tar.bz2](downloads/hipparchus-2.2-src.tar.bz2) | [md5](downloads/hipparchus-2.2-src.tar.bz2.md5) | [sig](downloads/hipparchus-2.2-src.tar.bz2.asc)|
|  binary (zip)     | [hipparchus-2.2-bin.zip](downloads/hipparchus-2.2-bin.zip)| [md5](downloads/hipparchus-2.2-bin.zip.md5) | [sig](downloads/hipparchus-2.2-bin.zip.asc)|
|  binary (tar.bz2) | [hipparchus-2.2-bin.tar.bz2](downloads/hipparchus-2.2-bin.tar.bz2) | [md5](downloads/hipparchus-2.2-bin.tar.bz2.md5) | [sig](downloads/hipparchus-2.2-bin.tar.bz2.asc)
version 2.2 downloads (release date: 2022-08-10)

---

|     package       |                                  link                                                     | hash | signature |
|-------------------|-------------------------------------------------------------------------------------------|------|-----------|
|  source (zip)     | [hipparchus-2.1-src.zip](downloads/hipparchus-2.1-src.zip) | [md5](downloads/hipparchus-2.1-src.zip.md5)| [sig](downloads/hipparchus-2.1-src.zip.asc)|
|  source (tar.bz2) | [hipparchus-2.1-src.tar.bz2](downloads/hipparchus-2.1-src.tar.bz2) | [md5](downloads/hipparchus-2.1-src.tar.bz2.md5) | [sig](downloads/hipparchus-2.1-src.tar.bz2.asc)|
|  binary (zip)     | [hipparchus-2.1-bin.zip](downloads/hipparchus-2.1-bin.zip)| [md5](downloads/hipparchus-2.1-bin.zip.md5) | [sig](downloads/hipparchus-2.1-bin.zip.asc)|
|  binary (tar.bz2) | [hipparchus-2.1-bin.tar.bz2](downloads/hipparchus-2.1-bin.tar.bz2) | [md5](downloads/hipparchus-2.1-bin.tar.bz2.md5) | [sig](downloads/hipparchus-2.1-bin.tar.bz2.asc)
version 2.1 downloads (release date: 2022-04-24)

---

|     package       |                                  link                                                     | hash | signature |
|-------------------|-------------------------------------------------------------------------------------------|------|-----------|
|  source (zip)     | [hipparchus-2.0-src.zip](downloads/hipparchus-2.0-src.zip) | [md5](downloads/hipparchus-2.0-src.zip.md5)| [sig](downloads/hipparchus-2.0-src.zip.asc)|
|  source (tar.bz2) | [hipparchus-2.0-src.tar.bz2](downloads/hipparchus-2.0-src.tar.bz2) | [md5](downloads/hipparchus-2.0-src.tar.bz2.md5) | [sig](downloads/hipparchus-2.0-src.tar.bz2.asc)|
|  binary (zip)     | [hipparchus-2.0-bin.zip](downloads/hipparchus-2.0-bin.zip)| [md5](downloads/hipparchus-2.0-bin.zip.md5) | [sig](downloads/hipparchus-2.0-bin.zip.asc)|
|  binary (tar.bz2) | [hipparchus-2.0-bin.tar.bz2](downloads/hipparchus-2.0-bin.tar.bz2) | [md5](downloads/hipparchus-2.0-bin.tar.bz2.md5) | [sig](downloads/hipparchus-2.0-bin.tar.bz2.asc)
version 2.0 downloads (release date: 2021-08-07)

---

|     package       |                                  link                                                     | hash | signature |
|-------------------|-------------------------------------------------------------------------------------------|------|-----------|
|  source (zip)     | [hipparchus-1.8-src.zip](downloads/hipparchus-1.8-src.zip) | [md5](downloads/hipparchus-1.8-src.zip.md5)| [sig](downloads/hipparchus-1.8-src.zip.asc)|
|  source (tar.bz2) | [hipparchus-1.8-src.tar.bz2](downloads/hipparchus-1.8-src.tar.bz2) | [md5](downloads/hipparchus-1.8-src.tar.bz2.md5) | [sig](downloads/hipparchus-1.8-src.tar.bz2.asc)|
|  binary (zip)     | [hipparchus-1.8-bin.zip](downloads/hipparchus-1.8-bin.zip)| [md5](downloads/hipparchus-1.8-bin.zip.md5) | [sig](downloads/hipparchus-1.8-bin.zip.asc)|
|  binary (tar.bz2) | [hipparchus-1.8-bin.tar.bz2](downloads/hipparchus-1.8-bin.tar.bz2) | [md5](downloads/hipparchus-1.8-bin.tar.bz2.md5) | [sig](downloads/hipparchus-1.8-bin.tar.bz2.asc)
version 1.8 downloads (release date: 2020-12-05)

---

|     package       |                                  link                                                     | hash | signature |
|-------------------|-------------------------------------------------------------------------------------------|------|-----------|
|  source (zip)     | [hipparchus-1.7-src.zip](downloads/hipparchus-1.7-src.zip) | [md5](downloads/hipparchus-1.7-src.zip.md5)| [sig](downloads/hipparchus-1.7-src.zip.asc)|
|  source (tar.bz2) | [hipparchus-1.7-src.tar.bz2](downloads/hipparchus-1.7-src.tar.bz2) | [md5](downloads/hipparchus-1.7-src.tar.bz2.md5) | [sig](downloads/hipparchus-1.7-src.tar.bz2.asc)|
|  binary (zip)     | [hipparchus-1.7-bin.zip](downloads/hipparchus-1.7-bin.zip)| [md5](downloads/hipparchus-1.7-bin.zip.md5) | [sig](downloads/hipparchus-1.7-bin.zip.asc)|
|  binary (tar.bz2) | [hipparchus-1.7-bin.tar.bz2](downloads/hipparchus-1.7-bin.tar.bz2) | [md5](downloads/hipparchus-1.7-bin.tar.bz2.md5) | [sig](downloads/hipparchus-1.7-bin.tar.bz2.asc)
version 1.7 downloads (release date: 2020-06-23)

---

|     package       |                                  link                                                     | hash | signature |
|-------------------|-------------------------------------------------------------------------------------------|------|-----------|
|  source (zip)     | [hipparchus-1.6-src.zip](downloads/hipparchus-1.6-src.zip) | [md5](downloads/hipparchus-1.6-src.zip.md5)| [sig](downloads/hipparchus-1.6-src.zip.asc)|
|  source (tar.bz2) | [hipparchus-1.6-src.tar.bz2](downloads/hipparchus-1.6-src.tar.bz2) | [md5](downloads/hipparchus-1.6-src.tar.bz2.md5) | [sig](downloads/hipparchus-1.6-src.tar.bz2.asc)|
|  binary (zip)     | [hipparchus-1.6-bin.zip](downloads/hipparchus-1.6-bin.zip)| [md5](downloads/hipparchus-1.6-bin.zip.md5) | [sig](downloads/hipparchus-1.6-bin.zip.asc)|
|  binary (tar.bz2) | [hipparchus-1.6-bin.tar.bz2](downloads/hipparchus-1.6-bin.tar.bz2) | [md5](downloads/hipparchus-1.6-bin.tar.bz2.md5) | [sig](downloads/hipparchus-1.6-bin.tar.bz2.asc)
version 1.6 downloads (release date: 2019-11-01)

---

|     package       |                                  link                                                     | hash | signature |
|-------------------|-------------------------------------------------------------------------------------------|------|-----------|
|  source (zip)     | [hipparchus-1.5-src.zip](downloads/hipparchus-1.5-src.zip) | [md5](downloads/hipparchus-1.5-src.zip.md5)| [sig](downloads/hipparchus-1.5-src.zip.asc)|
|  source (tar.bz2) | [hipparchus-1.5-src.tar.bz2](downloads/hipparchus-1.5-src.tar.bz2) | [md5](downloads/hipparchus-1.5-src.tar.bz2.md5) | [sig](downloads/hipparchus-1.5-src.tar.bz2.asc)|
|  binary (zip)     | [hipparchus-1.5-bin.zip](downloads/hipparchus-1.5-bin.zip)| [md5](downloads/hipparchus-1.5-bin.zip.md5) | [sig](downloads/hipparchus-1.5-bin.zip.asc)|
|  binary (tar.bz2) | [hipparchus-1.5-bin.tar.bz2](downloads/hipparchus-1.5-bin.tar.bz2) | [md5](downloads/hipparchus-1.5-bin.tar.bz2.md5) | [sig](downloads/hipparchus-1.5-bin.tar.bz2.asc)
version 1.5 downloads (release date: 2019-05-06)

---

|     package       |                                  link                                                     | hash | signature |
|-------------------|-------------------------------------------------------------------------------------------|------|-----------|
|  source (zip)     | [hipparchus-1.4-src.zip](downloads/hipparchus-1.4-src.zip) | [md5](downloads/hipparchus-1.4-src.zip.md5)| [sig](downloads/hipparchus-1.4-src.zip.asc)|
|  source (tar.bz2) | [hipparchus-1.4-src.tar.bz2](downloads/hipparchus-1.4-src.tar.bz2) | [md5](downloads/hipparchus-1.4-src.tar.bz2.md5) | [sig](downloads/hipparchus-1.4-src.tar.bz2.asc)|
|  binary (zip)     | [hipparchus-1.4-bin.zip](downloads/hipparchus-1.4-bin.zip)| [md5](downloads/hipparchus-1.4-bin.zip.md5) | [sig](downloads/hipparchus-1.4-bin.zip.asc)|
|  binary (tar.bz2) | [hipparchus-1.4-bin.tar.bz2](downloads/hipparchus-1.4-bin.tar.bz2) | [md5](downloads/hipparchus-1.4-bin.tar.bz2.md5) | [sig](downloads/hipparchus-1.4-bin.tar.bz2.asc)
version 1.4 downloads (release date: 2018-11-17)

---

|     package       |                                  link                                                     | hash | signature |
|-------------------|-------------------------------------------------------------------------------------------|------|-----------|
|  source (zip)     | [hipparchus-1.3-src.zip](downloads/hipparchus-1.3-src.zip) | [md5](downloads/hipparchus-1.3-src.zip.md5)| [sig](downloads/hipparchus-1.3-src.zip.asc)|
|  source (tar.bz2) | [hipparchus-1.3-src.tar.bz2](downloads/hipparchus-1.3-src.tar.bz2) | [md5](downloads/hipparchus-1.3-src.tar.bz2.md5) | [sig](downloads/hipparchus-1.3-src.tar.bz2.asc)|
|  binary (zip)     | [hipparchus-1.3-bin.zip](downloads/hipparchus-1.3-bin.zip)| [md5](downloads/hipparchus-1.3-bin.zip.md5) | [sig](downloads/hipparchus-1.3-bin.zip.asc)|
|  binary (tar.bz2) | [hipparchus-1.3-bin.tar.bz2](downloads/hipparchus-1.3-bin.tar.bz2) | [md5](downloads/hipparchus-1.3-bin.tar.bz2.md5) | [sig](downloads/hipparchus-1.3-bin.tar.bz2.asc)
version 1.3 downloads (release date: 2018-05-08)

---

|     package       |                                  link                                                     | hash | signature |
|-------------------|-------------------------------------------------------------------------------------------|------|-----------|
|  source (zip)     | [hipparchus-1.2-src.zip](downloads/hipparchus-1.2-src.zip) | [md5](downloads/hipparchus-1.2-src.zip.md5)| [sig](downloads/hipparchus-1.2-src.zip.asc)|
|  source (tar.bz2) | [hipparchus-1.2-src.tar.bz2](downloads/hipparchus-1.2-src.tar.bz2) | [md5](downloads/hipparchus-1.2-src.tar.bz2.md5) | [sig](downloads/hipparchus-1.2-src.tar.bz2.asc)|
|  binary (zip)     | [hipparchus-1.2-bin.zip](downloads/hipparchus-1.2-bin.zip)| [md5](downloads/hipparchus-1.2-bin.zip.md5) | [sig](downloads/hipparchus-1.2-bin.zip.asc)|
|  binary (tar.bz2) | [hipparchus-1.2-bin.tar.bz2](downloads/hipparchus-1.2-bin.tar.bz2) | [md5](downloads/hipparchus-1.2-bin.tar.bz2.md5) | [sig](downloads/hipparchus-1.2-bin.tar.bz2.asc)
version 1.2 downloads (release date: 2017-10-25)

---

|     package       |                                  link                                                     | hash | signature |
|-------------------|-------------------------------------------------------------------------------------------|------|-----------|
|  source (zip)     | [hipparchus-1.1-src.zip](downloads/hipparchus-1.1-src.zip) | [md5](downloads/hipparchus-1.1-src.zip.md5)| [sig](downloads/hipparchus-1.1-src.zip.asc)|
|  source (tar.bz2) | [hipparchus-1.1-src.tar.bz2](downloads/hipparchus-1.1-src.tar.bz2) | [md5](downloads/hipparchus-1.1-src.tar.bz2.md5) | [sig](downloads/hipparchus-1.1-src.tar.bz2.asc)|
|  binary (zip)     | [hipparchus-1.1-bin.zip](downloads/hipparchus-1.1-bin.zip)| [md5](downloads/hipparchus-1.1-bin.zip.md5) | [sig](downloads/hipparchus-1.1-bin.zip.asc)|
|  binary (tar.bz2) | [hipparchus-1.1-bin.tar.bz2](downloads/hipparchus-1.1-bin.tar.bz2) | [md5](downloads/hipparchus-1.1-bin.tar.bz2.md5) | [sig](downloads/hipparchus-1.1-bin.tar.bz2.asc)
version 1.1 downloads (release date: 2017-03-16)

---

|     package       |                                  link                                                     | hash | signature |
|-------------------|-------------------------------------------------------------------------------------------|------|-----------|
|  source (zip)     | [hipparchus-1.0-src.zip](downloads/hipparchus-1.0-src.zip) | [md5](downloads/hipparchus-1.0-src.zip.md5)| [sig](downloads/hipparchus-1.0-src.zip.asc)|
|  source (tar.bz2) | [hipparchus-1.0-src.tar.bz2](downloads/hipparchus-1.0-src.tar.bz2) | [md5](downloads/hipparchus-1.0-src.tar.bz2.md5) | [sig](downloads/hipparchus-1.0-src.tar.bz2.asc)|
|  binary (zip)     | [hipparchus-1.0-bin.zip](downloads/hipparchus-1.0-bin.zip)| [md5](downloads/hipparchus-1.0-bin.zip.md5) | [sig](downloads/hipparchus-1.0-bin.zip.asc)|
|  binary (tar.bz2) | [hipparchus-1.0-bin.tar.bz2](downloads/hipparchus-1.0-bin.tar.bz2) | [md5](downloads/hipparchus-1.0-bin.tar.bz2.md5) | [sig](downloads/hipparchus-1.0-bin.tar.bz2.asc)
version 1.0 downloads (release date: 2016-06-23)
