<!--
 Licensed to the Hipparchus project under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The Hipparchus project licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

      https://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->
# Exceptions

All exceptions generated by the
Hipparchus code are <em>unchecked</em> (i.e. they inherit from
the standard `RuntimeException` class).
The main rationale supporting this design decision is that the
exceptions generated in the library are not recoverable: They most
of the time result from bad input parameters or some failure due to
numerical problems.

All Hipparchus exceptions are inherit from a common root, `org.hipparchus.exception.MathRuntimeException.`

The detailed error messages (i.e. the string returned by the getLocalizedMessage method) can be localized. However, besides the American/English default, French is the only language for which a translation resource is available.

Exceptions generated by public methods are advertised and documented in javadoc.