import numpy as np
import matplotlib.pyplot as plt
from scipy.io import netcdf_file

# Reads the NETCDF file
f = netcdf_file('figure5b_data.nc', 'r')
print(f.history)
print(f.dimensions)
print(f.variables)
r   = f.variables['r'][:].copy()
d1  = f.variables['d1'][:].copy()
d1g = f.variables['d1g'][:].copy()
f.close()

# Plots the data
plt.figure(figsize=(7,4))
plt.plot(r,d1,'r',label=r'St=1')
plt.plot(r,d1g,'b--',label=r'St=1 with gravity')
plt.xlabel('r [km]')
plt.ylabel(r'$n_A / \langle n_A \rangle$')
plt.xlim([0,94])
plt.ylim([0,5])
plt.legend(loc='upper right')
plt.tight_layout()
plt.show()
