import numpy as np
import matplotlib.pyplot as plt
from scipy.io import netcdf_file

# Reads the NETCDF file
f = netcdf_file('figure5a_data.nc', 'r')
print(f.history)
print(f.dimensions)
print(f.variables)
freq   = f.variables['freq'][:].copy()
specvx = f.variables['specvx'][:].copy()
specvz = f.variables['specvz'][:].copy()
f.close()

# Plots the data
plt.figure(figsize=(7,4))
plt.loglog(freq,specvx,label=r'$v_x$')
plt.loglog(freq,specvz,label=r'$v_z$')
plt.xlabel(r'$\omega$ [1/s]')
plt.ylabel(r'$E(\omega)$ [m$^2$/s]')
plt.xlim([2e-3,6e-1])
plt.ylim([4e-5,400])
plt.legend(loc='upper right')
plt.tight_layout()
plt.show()
