import numpy as np
import matplotlib.pyplot as plt
from scipy.io import netcdf_file

# Reads the NETCDF file
f = netcdf_file('figure4_data.nc', 'r')
print(f.history)
print(f.dimensions)
print(f.variables)
rad     = f.variables['rad'][:].copy()
time_na = f.variables['time_na'][:].copy()
na      = f.variables['na'][:,:].copy()
time    = f.variables['time'][:].copy()
cloudr  = f.variables['cloudr'][:].copy()
maxnac  = f.variables['maxnac'][:].copy()
f.close()

# Plots the data
fig, (ax0, ax1) = plt.subplots(2, 1,figsize=(7,6))
ax0.imshow(na,aspect='auto',origin='lower',
  extent=(min(time_na),max(time_na),min(rad),max(rad)),vmax=1)
ax0.plot(time,cloudr,'w',label='Cloud')
ax0.plot(time,maxnac,'ro',label=r'$\max\{N_{A,C}\}$')
ax0.set_xlabel('Time [min]')
ax0.set_ylabel('Radius [km]')
ax0.legend(loc='upper left')
ax1.loglog(time,cloudr,'k',label='Cloud')
ax1.loglog(time,maxnac,'ro',label=r'$\max\{N_{A,C}\}$')
ax1.set_xlabel('Time [min]')
ax1.set_ylabel('Radius [km]')
ax1.set_xlim([10,60])
ax1.set_ylim([10,150])
ax1.legend(loc='upper left')
plt.tight_layout()
plt.show()
