import numpy as np
import matplotlib.pyplot as plt
from scipy.io import netcdf_file

# Reads the NETCDF file
f = netcdf_file('figure3_data.nc', 'r')
print(f.history)
print(f.dimensions)
print(f.variables)
r    = f.variables['r'][:].copy()
w2   = f.variables['w2'][:].copy()
d1   = f.variables['d1'][:].copy()
d01  = f.variables['d01'][:].copy()
d001 = f.variables['d001'][:].copy()
dice = f.variables['dice'][:].copy()
nac  = f.variables['nac'][:].copy()
nic  = f.variables['nic'][:].copy()
naa  = f.variables['naa'][:].copy()
ncc  = f.variables['ncc'][:].copy()
f.close()

# Plots the data
fig, (ax0, ax1) = plt.subplots(2, 1,figsize=(7,8))
ax0.plot(r,w2,'--',linewidth=3,
  label=r'$\omega^2 / \langle \omega^2 \rangle$')
ax0.plot(r,d1,'r',
  label=r'$n_A / \langle n_A \rangle$ (St=1)')
ax0.plot(r,d01,'c',
  label=r'$n_B / \langle n_B \rangle$ (St=0.1)')
ax0.plot(r,d001,'m',
  label=r'$n_C / \langle n_C \rangle$ (St=0.01)')
ax0.plot(r,dice,
  label=r'$n_{ISP} / \langle n_{ISP} \rangle$ (St=1)')
ax0.set_xlabel('r [km]')
ax0.set_xlim([0,94])
ax0.set_ylim([0,5])
ax0.legend(loc='upper right',ncol=2)
ax1.semilogy(r,nac,'--',linewidth=3,
  label=r'$N_{A,C} / \langle N_{A,C} \rangle$')
ax1.semilogy(r,nic,'--',linewidth=3,
  label=r'$N_{ISP,C} / \langle N_{ISP,C} \rangle$')
ax1.semilogy(r,naa,'r',
  label=r'$N_{A,A} / \langle N_{A,A} \rangle$')
ax1.semilogy(r,ncc,'m',
  label=r'$N_{C,C} / \langle N_{C,C} \rangle$')
ax1.set_xlabel('r [km]')
ax1.set_xlim([0,94])
ax1.set_ylim([1e-2,20])
ax1.legend(loc='upper right',ncol=2)
plt.tight_layout()
plt.show()
