*** Data preparation ***
*Import data from Excel file
import excel "Koiek_et_al_2023.xlsx", sheet("SRT data") firstrow clear
*Keep only rows with data
keep if strpos(ID,"eg")>0 | strpos(ID,"cg")>0
*Fill out Group variable
replace Group = Group[_n-1] if Group==""
*Generate numerical (factor) group variable
encode Group, gen(group)
drop Group
*Generate numerical id variable
gen id_pre1 = substr(ID,3,3)
destring id_pre1, gen(id_pre2)
gen id = cond(group==1,10000+id_pre2,20000+id_pre2)
drop ID id_pre1 id_pre2
*Make durations/ages numerical
destring OverallOMduration, gen(Duration) force
destring OMonsetage, gen(Onsetage) force
destring OMrecoveryperiod, gen(Recoveryperiod) force
drop OverallOMduration OMonsetage OMrecoveryperiod
*Put variables in nice order
order id group Age Duration Onsetage Recoveryperiod MonauralSRT BinauralSRT ColocatedSRT SpatiallysepSRT
*Reshape to long data format
rename MonauralSRT SRTMonaural
rename BinauralSRT SRTBinaural
rename ColocatedSRT SRTColocated
rename SpatiallysepSRT SRTSpatiallysep
reshape long SRT, i(id) j(type_pre) string
encode type_pre, gen(type)
drop type_pre

*** 
codebook type
*1  Binaural
*2  Colocated
*3  Monaural
*4  Spatiallysep

bysort group type: summ SRT
mixed SRT i.type#i.group i.type c.Age  || id:, reml dfmethod(repeated)  res(,by(type))
testparm i.type#i.group

mixed SRT i.type i.group c.Age  || id:, reml dfmethod(repeated)  res(,by(type))
testparm i.group

regress SRT c.Age c.Duration c.Onsetage c.Recoveryperiod if type==1 & group==2
regress SRT c.Age c.Duration c.Onsetage c.Recoveryperiod if type==2 & group==2
regress SRT c.Age c.Duration c.Onsetage c.Recoveryperiod if type==3 & group==2
regress SRT c.Age c.Duration c.Onsetage c.Recoveryperiod if type==4 & group==2



import excel "Koiek_et_al_2023.xlsx", sheet("Advantage scores") firstrow clear
*Keep only rows with data
keep if strpos(ID,"eg")>0 | strpos(ID,"cg")>0
*Fill out Group variable
replace Group = Group[_n-1] if Group==""
*Generate numerical (factor) group variable
encode Group, gen(group)
drop Group
*Generate numerical id variable
gen id_pre1 = substr(ID,3,3)
destring id_pre1, gen(id_pre2)
gen id = cond(group==1,10000+id_pre2,20000+id_pre2)
drop ID id_pre1 id_pre2
*Make durations/ages numerical
destring OverallOMduration, gen(Duration) force
destring OMonsetage, gen(Onsetage) force
destring OMrecoveryperiod, gen(Recoveryperiod) force
drop OverallOMduration OMonsetage OMrecoveryperiod
*Put variables in nice order
order id group Age Duration Onsetage Recoveryperiod Binauraladv Spatialadv
*Reshape to long data format
rename Binauraladv ADVBinaural
rename Spatialadv ADVSpatial
reshape long ADV, i(id) j(type_pre) string
encode type_pre, gen(type)
drop type_pre

*** 
codebook type
*1  Binaural
*2  Spatial

bysort group type: summ ADV
mixed ADV i.type#i.group i.type c.Age  || id:, reml dfmethod(repeated)  res(,by(type))
testparm i.type#i.group

mixed ADV i.type i.group c.Age  || id:, reml dfmethod(repeated)  res(,by(type))
testparm i.group

regress ADV c.Age c.Duration c.Onsetage c.Recoveryperiod if type==1 & group==2
regress ADV c.Age c.Duration c.Onsetage c.Recoveryperiod if type==2 & group==2
