#
# Parameter optimization of qthr of SPEEDY
#
from pylab import *
import numpy as np
import matplotlib.pyplot as plt
import numpy.ma as ma
import struct
from scipy.io import FortranFile
from sklearn.gaussian_process import kernels as sk_kern
from sklearn.gaussian_process import GaussianProcessRegressor


def costfunc(mean, std, obserr, ans, dim):
    cost1 = 0
    cost2 = 0
    for i in range(0,dim):
     cost1 += 0.5*((mean[i]-ans[i])**2/((std[i]+obserr[i])**2))
     #cost1 += 0.5*((mean[i]-ans[i])**2/(obserr[i]**2))
     #cost1 += 1/2*((mean-ans)**2/((std+obserr)**2))
#     cost2 += std[i]**2 + obserr[i]**2
    #for i in range(0, ndim):
     #cost2 += 0.5*(inputx[0,i]-0.5)**2/0.10
    return cost1 + cost2


#
# configurations
#
Nens = 100   # ensemble size
Nobs = 1   # observation size
xx = 9     # dimension

#
# start constructing surrogate models
#
x_train = np.linspace(0, 1, Nens)
data = np.loadtxt('../DATA_foropt_20230819/clim/qdifftrop.txt').reshape(8,100)
y_train = data[0:2,:].T
#y_train = np.loadtxt('costlist').T
kernel = sk_kern.Matern()
clf0 = GaussianProcessRegressor(
        kernel=kernel,
        alpha=1e-10,
        optimizer="fmin_l_bfgs_b",
        n_restarts_optimizer=80,
        normalize_y=True)
clf0.fit(x_train[:].reshape(-1,1),y_train[:,0])
clf1 = GaussianProcessRegressor(
        kernel=kernel,
        alpha=1e-10,
        optimizer="fmin_l_bfgs_b",
        n_restarts_optimizer=80,
        normalize_y=True)
clf1.fit(x_train[:].reshape(-1,1),y_train[:,1])


# test ----------------------------------------------
testsample = np.random.rand(100)
#testsample = 3 + (15-3)*testsample
pred_mean,predstd = clf0.predict(testsample.reshape(-1,1),return_std=True)
#print(pred_mean,predstd)
plt.scatter(testsample,pred_mean/0.00001)
plt.show()
pred_mean,predstd = clf1.predict(testsample.reshape(-1,1),return_std=True)
#print(pred_mean,predstd)
plt.scatter(testsample,pred_mean/0.00001)
plt.show()

# test -------------------------------------------------

#sys.exit()


#
# MCMC Sampler
#
iteration = 500000
ndim = 1
sdim = 2

#obserr = [0.001,0.001] # sampletime=1000
obserr = [0.001,0.001] # sampletime=1000


# define variables
x = np.zeros((iteration,ndim))
pred_mean = np.zeros((sdim))
pred_std = np.zeros((sdim))
obsstat = np.zeros((sdim))

x[0,:] = 0.5 # initial contidion

# prediction
inputx = np.zeros((ndim))
inputx = x[0,:].reshape(-1,1)
pred_mean[0],pred_std[0] = clf0.predict(inputx,return_std=True)
pred_mean[1],pred_std[1] = clf1.predict(inputx,return_std=True)
f = costfunc(np.sqrt(pred_mean),pred_std,obserr,obsstat,2)

#print('first f = ', f)
#print('Start MCMC sampler')

for t in range(1,iteration):
    print('sampling no. ', t)

    #
    # sampling new proposal
    #
    proposedx = - np.ones((ndim))
    for i in range (0,ndim):
        while proposedx[i] < 0 or proposedx[i] > 1:
            proposedx[i] = np.random.normal(x[t-1,i],0.05)
    #
    # evaluate proposal
    #
    inputx = proposedx.reshape(-1,1)
    pred_mean[0],pred_std[0] = clf0.predict(inputx,return_std=True)
    pred_mean[1],pred_std[1] = clf1.predict(inputx,return_std=True)
    proposedf = costfunc(np.sqrt(pred_mean),pred_std,obserr,obsstat,2)

    alpha = min(1,exp(-(proposedf-f)))
    #print(pred_mean,obsstat)
    print(f, proposedf, alpha, x[t-1,:])
    #
    # sampling/rejecting
    #
    if alpha > 1:
        x[t,:] = proposedx
        f = proposedf
    else:
        rottery = np.random.rand()
        if rottery < alpha:
            x[t,:] = proposedx
            f = proposedf
        else:
            x[t,:] = x[t-1,:]

#
# output
#
np.savetxt('MCMCsamples_3',x)





