#!/bin/bash
#=======================================================================
# run_first
#   To run the SPEEDY model for the first time. That is, you do not have
#   a gridded initial condition, so that the model starts from the
#   atmosphere at rest. The atmosphere at rest means zero winds
#   everywhere and constant T with vertical profile of the standard
#   atmosphere.
#=======================================================================

# Directory settings
SPEEDY=~/research/speedy/speedy-letkf
MEMB=100
MM=1
NN=0
NNODE=10
while test $MM -le $MEMB
do
        NATURE=$SPEEDY/DATA/nature$MM
	WORKDIR=$SPEEDY/model_para/tmp$MM
	QTHR=$MM
	bash run_cycle_manypara.sh $NATURE $WORKDIR $QTHR > log$MM &
	sleep 10
	NN=`expr $NN + 1`
	MM=`expr $MM + 1`
        if test $NN -gt $NNODE
	then
	     time wait
	     NN=0
	fi
done

