#
# Analyzing F and state variables in two-scale Lorenz96
# Mimicking Pathiraja and van Leeuwen 2022 JAMES
# Y.Sawada 20221220
#

from pylab import *
import numpy as np
import matplotlib.pyplot as plt
import numpy.ma as ma
import struct
from scipy.io import FortranFile

#
# configurations
#
xx = 9     # dimension
tt = 14400 # total time it should be 14400
dataf = np.zeros((tt,xx))
datax = np.zeros((tt,xx))

f = FortranFile('../DATA/force.dat','r')
for i in range(0,tt):
    dataf[i,:] = f.read_reals(float32)
#    print(f.read_reals(float32))

f = FortranFile('../DATA/naturex.dat','r')
for i in range(0,tt):
    datax[i,:] = f.read_reals(float32)

plt.plot(datax[0,:])
plt.show()

#plt.plot(datax[4400:,0]**2)
#plt.show()
print(np.mean(datax[4400:4500,0]**2))
print(np.mean(datax[5400:5500,2]**2))
print(np.mean(datax[6400:6500,4]**2))
print(np.mean(datax[7400:7500,6]**2))
print(np.mean(datax[8400:8500,8]**2))

#print(np.std(datax[4400:4900,0])/np.mean(datax[4400:4900,0]))
#print(np.std(datax[5400:5900,2])/np.mean(datax[5400:5900,2]))
#print(np.std(datax[6400:6900,4])/np.mean(datax[6400:6900,4]))
#print(np.std(datax[7400:7900,6])/np.mean(datax[7400:7900,6]))
#print(np.std(datax[8400:8900,8])/np.mean(datax[8400:8900,8]))



plt.contourf(datax[5000:5100,:])
plt.colorbar()
plt.show()
plt.contourf(dataf[5000:5100,:])
plt.colorbar()
plt.show()

plt.scatter(datax[1000:2000,1],dataf[1000:2000,1]-14.0)
#plt.savefig('./force_x.png')
plt.show()

