!
! Generating climatology for optimizing "F"
! YSaw 20221206
!

PROGRAM spinup
  USE common
  USE lorenz96
!  USE lorenz96_oro

  IMPLICIT NONE

  REAL(r_size) :: x(nx)
  REAL(r_sngl) :: x4(nx)
  INTEGER :: i,j,ktoneday,ktcyc
  INTEGER,PARAMETER :: Nens=100      ! total number of parameter ensemble
  REAL,PARAMETER :: force_min=1.0d0  ! parameter range
  REAL,PARAMETER :: force_max=30.0d0 ! parameter range
  CHARACTER(20):: cnumber,filename

  dt=0.005d0
  !force=8.0d0
  oneday=0.2d0

  ktoneday = INT(oneday/dt)
  ktcyc = ktoneday/4

  DO i=1, Nens
   !
   ! parameter specification
   !
   force=force_min+i*(force_max-force_min)/DBLE(Nens)

   !
   ! initialization
   !
   CALL com_randn(nx,x)
   x = x * 5.0d0

   !
   ! output file
   !
   WRITE(cnumber,*),i
   filename = 'manypara'//trim(adjustl(cnumber))//'.dat'
   OPEN(90,FILE=filename,FORM='unformatted')

   !
   ! model integration
   !
   DO j=1,360*100*4
    x4 = x
    WRITE(90) x4
    CALL tinteg_rk4(ktcyc,x,x) ! 100 years integration
   ENDDO ! j loop
   PRINT*, "member", i

  ENDDO ! i loop
  STOP
END PROGRAM spinup
