#
# Parameter optimization of F of lorenz96 
#
from pylab import *
import numpy as np
import matplotlib.pyplot as plt
import numpy.ma as ma
import struct
from scipy.io import FortranFile
from sklearn.gaussian_process import kernels as sk_kern
from sklearn.gaussian_process import GaussianProcessRegressor


#
# observation
#
Nobs_obs = 4
tt_obs = 14400
xx = 9
filename = '../DATA/naturex.dat'
f = FortranFile(filename,'r')
nature = np.zeros((tt_obs,xx))
observationerror = 0.1
for t in range(0,tt_obs):
    nature[t,:] = f.read_reals(float32)
hope_obs = np.zeros((Nobs_obs))
hope_obs[0] = 0 
hope_obs[1] = 1 
hope_obs[2] = 4 
hope_obs[3] = 5 
hope_obs = hope_obs.astype(int)

obs = np.zeros((tt_obs,Nobs_obs))
for t in range(0,tt_obs):
    for i in range(0,Nobs_obs):
        obsr = np.random.randn() * observationerror
        obs[t,i] = obsr + nature[t,hope_obs[i]]

iteration = 10000
sampletime = 100
obsstat = np.zeros((iteration,6))
for t in range (0,iteration):
    time = int(np.random.uniform(0,tt_obs-sampletime-6))
    location = np.random.randint(0,3)
    obsstat[t,0] = np.mean(obs[time:time+sampletime,location]**2)
    obsstat[t,1] = np.std(obs[time:time+sampletime,location])/np.mean(obs[time:time+sampletime,location])
    obsstat[t,2] = np.corrcoef(obs[time:time+sampletime,location],obs[time+1:time+1+sampletime,location])[0,1]
    obsstat[t,3] = np.corrcoef(obs[time:time+sampletime,location],obs[time+2:time+2+sampletime,location])[0,1]
    obsstat[t,4] = np.corrcoef(obs[time:time+sampletime,location],obs[time+3:time+3+sampletime,location])[0,1]
    obsstat[t,5] = np.corrcoef(obs[time:time+sampletime,location],obs[time+4:time+4+sampletime,location])[0,1]
    print(obsstat[t,:])
print('obserr 1 ', np.std(obsstat[:,0]))
print('obserr 2 ', np.std(obsstat[:,1]))
print('obserr 3 ', np.std(obsstat[:,2]))
print('obserr 4 ', np.std(obsstat[:,3]))
print('obserr 5 ', np.std(obsstat[:,4]))
print('obserr 5 ', np.std(obsstat[:,5]))
print('obsmean 1 ', np.mean(obsstat[:,0]))
print('obsmean 2 ', np.mean(obsstat[:,1]))
print('obsmean 3 ', np.mean(obsstat[:,2]))
print('obsmean 4 ', np.mean(obsstat[:,3]))
print('obsmean 5 ', np.mean(obsstat[:,4]))
print('obsmean 6 ', np.mean(obsstat[:,5]))



