PROGRAM obsmake
!=======================================================================
! simulate observation data
!=======================================================================

! Version for HOOPE-EnKF
! parameters optimized by batch optimization are recognized as observation.
! Y.Saw 20230119

  USE common
  USE lorenz96
  USE h_ope

  IMPLICIT NONE

  INTEGER,PARAMETER :: ndays=3600
  INTEGER,PARAMETER :: nt=ndays*4
  REAL(r_size),PARAMETER :: obserr=0.1d0 ! this is state observation
  REAL(r_sngl) :: x4(nx)
  REAL(r_size) :: x(nx)
  REAL(r_size) :: ober(ny*nt)
  REAL(r_size) :: y(ny+np) !augmented state vector Y.Saw 20230119
  REAL(r_sngl) :: y4(ny+np) !augmented state vector Y.Saw 20230119
  INTEGER :: it
  INTEGER :: i,j,k
  REAL(r_size) :: obs_para(np) ! optimized parameter value Y.Saw 20230119


  CALL com_randn(ny*nt,ober)
  ober = ober * obserr
  k=0
  obs_para(:) = 12.3 !13.09 !11.22 ! the case of 100 timestep climatorogy in case study 2
  DO it=1,nt
    !
    ! nature run <- fort.10
    !
    READ(10) x4
    x = REAL(x4,r_size)
    CALL set_h(x)
    !
    ! Hx + ober
    !
    DO j=1,ny
      k = k+1
      y(j) = ober(k)
      DO i=1,nx
        y(j) = y(j) + h(j,i) * x(i)
      END DO
    END DO
    !
    ! parameters
    !
    DO j = 1, np
      y(ny+j) = obs_para(j)
    ENDDO
    !
    ! obs data -> fort.91
    !
    y4 = y
    PRINT*, y4
    WRITE(91) y4
  END DO

  STOP
END PROGRAM obsmake
