PROGRAM letkf
!=======================================================================
! 4D-LETKF with Lorenz-96
! Parameter optimization version
! by Y.Sawada 20230113
! parameter search by Y.Sawada 20230304
!=======================================================================
  USE common
  USE common_letkf
  USE lorenz96
!  USE lorenz96_oro
  USE h_ope

  IMPLICIT NONE

  INCLUDE 'mpif.h' ! YSaw 20230302
  LOGICAL,PARAMETER :: msw_detailout=.TRUE. ! YSaw 20221206
  INTEGER,PARAMETER :: ndays=360*5
  INTEGER,PARAMETER :: nt=ndays*8-1 !4
  INTEGER,PARAMETER :: nwindow=1 ! time window for 4D-LETKF
  INTEGER,PARAMETER :: nspinup=360*3*4 ! time steps for spin-up
  INTEGER,PARAMETER :: msw_local=0 ! localization mode switch
  INTEGER,PARAMETER :: np = nx     ! the number of parameters by YSaw
! msw_local : localization mode switch
!  0 : fixed localization
!  1 : adaptive localization
!  2 : combination of both
  REAL(r_size) :: xlocal=3.0d0 ! localization scale
  REAL(r_size),PARAMETER :: tlocal=2.0d0 ! time localization scale
! negative value for no time localization
  REAL(r_size) :: sa=1.0d0 ! adaptive localization parameter
  REAL(r_size) :: sb=1.0d0 ! adaptive localization parameter
  REAL(r_size),PARAMETER :: msw_infl_min=1.05d0 !1.05d0 ! inflation mode switch
  REAL(r_size),PARAMETER :: msw_infl_max=2.55d0 !2.00d0 ! inflation mode switch
  REAL(r_size),PARAMETER :: msw_infl_para_min=1.05d0 !1.05d0 ! inflation mode switch
  REAL(r_size),PARAMETER :: msw_infl_para_max=7.05d0 !5.00d0 ! inflation mode switch
  REAL(r_size) :: msw_infl, msw_infl_para
  REAL(r_size),ALLOCATABLE :: parabox(:,:,:)
  LOGICAL,PARAMETER :: AdaptiveInfl = .FALSE. ! YSaw 20230306
  LOGICAL,PARAMETER :: RTPPInfl = .FALSE. ! YSaw 20230323
! msw_infl : inflation mode switch
!  < 0 : adaptive inflation
!  > 0 : fixed inflation value
  REAL(r_size) :: parm_infl(nx+np,nt) ! inflation parameter np+np: augmented state vector Y.Saw
  REAL(r_size) :: parm, parms(4), gain, sigma_o
  REAL(r_size) :: parm_dummy=1.0d0
  REAL(r_size) :: xmaxloc
  REAL(r_size) :: obserr=0.1d0
  REAL(r_size) :: obserr_para=3.15d0 ! YSaw
  REAL(r_size) :: obs_para = 12.3d0 ! YSaw
  REAL(r_sngl) :: y4(ny)
  REAL(r_sngl) :: x4(nx)
  REAL(r_sngl) :: x4_long(nx+np) ! YSaw
  REAL(r_size) :: xnature(nx,nt)
  REAL(r_size) :: xa(nx+np,nbv,nwindow) !nx+np: augmented state vector Y.Saw
  REAL(r_size) :: xf(nx+np,nbv,nwindow) !nx+np: augmented state vector Y.Saw
  REAL(r_size) :: dxf(nx+np,nbv,nwindow)!nx+np: augmented state vector Y.Saw
  REAL(r_size) :: dxa(nx+np,nbv,nwindow)!nx+np: augmented state vector Y.Saw Analysis perturbation
  REAL(r_size) :: xm(nx+np,nwindow)     !nx+np: augmented state vector Y.Saw
  REAL(r_size) :: xam(nx+np,nwindow)     !nx+np: augmented state vector Y.Saw
  REAL(r_size) :: y(ny,nwindow)
  REAL(r_size) :: d(ny,nwindow)
  REAL(r_size) :: h4d(ny,nx+np,nwindow) !np+np: augmented state vector
  REAL(r_size) :: hxf(ny,nbv,nwindow)
  REAL(r_size) :: hxfm(ny,nwindow)
  REAL(r_size) :: hdxf(ny,nbv,nwindow)
  REAL(r_size) :: rdiag_loc(ny*nwindow)
  REAL(r_size) :: rloc_loc(ny*nwindow)
  REAL(r_size) :: d_loc(ny*nwindow)
  REAL(r_size) :: hdxf_loc(ny*nwindow,nbv)
  REAL(r_size) :: trans(nbv,nbv)
  REAL(r_size) :: dist,tdif
  REAL(r_size) :: rmse_t(nt),sprd_t(nt),infl_t(nt)
  REAL(r_size) :: rmse_x(nx),sprd_x(nx),infl_x(nx)
  REAL(r_size) :: rmseave,sprdave,inflave
  REAL(r_size) :: obsloc(3),wa,wb
  INTEGER :: irmse
  INTEGER :: ktoneday
  INTEGER :: ktcyc
  INTEGER :: i,j,n,nn,it,ios
  INTEGER :: ix
  INTEGER :: ixloc,jloc ! YSaw
  INTEGER :: ny_loc
  INTEGER :: nbv2
  INTEGER :: ierr, petot, my_rank, sqpetot ! YSaw 20230304
  CHARACTER(10) :: initfile='init00.dat'
  CHARACTER(10) :: my_rank_name ! YSaw 20230304

!-----------------------------------------------------------------------
! call mpi
!-----------------------------------------------------------------------
  CALL MPI_Init(ierr)
  CALL MPI_COMM_size(MPI_COMM_WORLD,petot,ierr)
  CALL MPI_COMM_rank(MPI_COMM_WORLD,my_rank,ierr)
!-----------------------------------------------------------------------
! model parameters
!-----------------------------------------------------------------------
  sqpetot = INT(SQRT(REAL(petot)))
  ALLOCATE(parabox(sqpetot,sqpetot,2))
  DO i = 1, sqpetot
   DO j = 1, sqpetot
     parabox(i,j,1) = msw_infl_min + (i-1) * (msw_infl_max - msw_infl_min)/sqpetot !state inflation
     parabox(i,j,2) = msw_infl_para_min + (j-1) * (msw_infl_para_max - msw_infl_para_min)/sqpetot ! para inflation
   ENDDO
  ENDDO
  msw_infl = parabox(mod(my_rank+1,sqpetot),(my_rank+1)/sqpetot+1,1)
  msw_infl_para = parabox(mod(my_rank+1,sqpetot),(my_rank+1)/sqpetot+1,2)
  PRINT*, 'inflation factors',  msw_infl, msw_infl_para, my_rank
  IF (AdaptiveInfl) THEN
          msw_infl = -1.0d0 ! <0 means adaptive inflation
  ENDIF
  dt=0.0005d0
  force=13.09d0 !8.0d0
  oneday=0.2d0
  ktoneday = INT(oneday/dt)
  ktcyc = ktoneday/4
  xmaxloc = xlocal * 2.0d0 * SQRT(10.0d0/3.0d0)
  nbv2 = CEILING(REAL(nbv)/2.0)
  PRINT '(A)'     ,'==========LETKF settings=========='
  PRINT '(A,I8)'  ,' nbv       : ',nbv
  PRINT '(A,I8)'  ,' ny        : ',ny
  PRINT '(A,I8)'  ,' nwindow   : ',nwindow
  PRINT '(A,I8)'  ,' msw_local : ',msw_local
  PRINT '(A,F8.1)',' xlocal    : ',xlocal
  PRINT '(A,F8.1)',' tlocal    : ',tlocal
  PRINT '(A,F8.1)',' sa        : ',sa
  PRINT '(A,F8.1)',' sb        : ',sb
  PRINT '(A,F8.2)',' msw_infl  : ',msw_infl
  PRINT '(A)'     ,'=================================='
!-----------------------------------------------------------------------
! nature
!-----------------------------------------------------------------------
  OPEN(10,FILE='naturex.dat',FORM='unformatted')
  DO i=1,nt
    READ(10) x4
    xnature(:,i) = REAL(x4,r_size)
  END DO
  CLOSE(10)
!-----------------------------------------------------------------------
! initial conditions 'initXX.dat'
!-----------------------------------------------------------------------
! State variables
  DO i=1,nbv
    WRITE(initfile(5:6),'(I2.2)') i-1
    OPEN(10,FILE=initfile,FORM='unformatted')
    READ(10) xf(1:nx,i,1) ! YSaw
    CLOSE(10)
  END DO
! Parameters
  DO i=1,nbv
    !CALL com_randn(np,xf(nx+1:nx+np,i,1)) ! fixed parameters
    CALL com_rand(np,xf(nx+1:nx+np,i,1)) ! fixed parameters
    !xf(nx+1:nx+np,i,1) = force + xf(nx+1:nx+np,i,1) * 2.471d0 !1.22d0
    xf(nx+1:nx+np,i,1) = 1.0d0 + xf(nx+1:nx+np,i,1) * 29.0d0 ! drawn from Uniform dist.
    !PRINT*, 'at ', i, 'para = ', xf(nx+1:nx+np,i,1)
  ENDDO 
!-----------------------------------------------------------------------
! main
!-----------------------------------------------------------------------
  irmse = 0
  rmse_t = 0.0d0
  rmse_x = 0.0d0
  sprd_t = 0.0d0
  sprd_x = 0.0d0
  infl_t = 0.0d0
  infl_x = 0.0d0
  parm_infl(1:nx,1) = ABS(msw_infl)
  parm_infl(nx+1:nx+np,1) = ABS(msw_infl_para) ! different inflation factor for parameter Y.Saw
  !
  ! input files
  !
  OPEN(11,FILE='obs.dat',FORM='unformatted')
  !
  ! output files
  !
  WRITE(my_rank_name,'(i4.4)') my_rank
  OPEN(90,FILE='guesmean'//TRIM(my_rank_name)//'.dat',FORM='unformatted')
  OPEN(91,FILE='analmean'//TRIM(my_rank_name)//'.dat',FORM='unformatted')
  OPEN(92,FILE='gues'//TRIM(my_rank_name)//'.dat',FORM='unformatted')
  OPEN(93,FILE='anal'//TRIM(my_rank_name)//'.dat',FORM='unformatted')
  !>>>
  !>>> LOOP START
  !>>>
  it=1
  DO
    !PRINT *, 'now at ', it
    !
    ! read obs
    !
    DO i=1,nwindow
      READ(11) y4
      y(:,i) = REAL(y4,r_size)
    END DO
    !
    ! 4d first guess
    !
    IF(nwindow > 1) THEN
      DO i=2,nwindow
        DO j=1,nbv
          CALL tinteg_rk4_varyingF(ktcyc,xf(1:nx,j,i-1),xf(nx+1:nx+np,j,i-1),xf(1:nx,j,i))
          xf(nx+1:nx+np,i,1) = xa(nx+1:nx+np,i,nwindow) ! persistent for parameter Y.Saw
        END DO
      END DO
    END IF
    !
    ! ensemble mean -> xm
    !
    DO j=1,nwindow
      CALL hoopeot(xf(nx+1:nx+np,:,j),obs_para,obserr_para,np,parm_infl(nx+1:nx+np,it+j-1)) 
    ENDDO
    DO j=1,nwindow
      DO i=1,nx + np ! YSaw
        CALL com_mean(nbv,xf(i,:,j),xm(i,j))
      END DO
    END DO
    !
    ! ensemble ptb -> dxf
    !
    DO j=1,nwindow
      DO i=1,nbv
        dxf(:,i,j) = xf(:,i,j) - xm(:,j)
        !PRINT*, "dxf = ", dxf(:,i,j), i
      END DO
    END DO
    !
    ! output first guess
    !
    IF(msw_detailout) THEN
      DO j=1,nwindow
        x4_long = xm(:,j)
        WRITE(90) x4_long
    !    DO i=1,nbv
    !      x4_long = xf(:,i,j)
    !      WRITE(92) x4_long
    !    END DO
      END DO
    END IF
    !---------------
    ! analysis step
    !---------------
    !
    ! hxf = H xf
    !
    ! State
    DO n=1,nwindow
      DO j=1,nbv
        CALL set_h(xf(:,j,n))
        h4d(:,1:nx,n) = h
        h4d(:,nx+1:nx+np,n) = 0.0d0 ! Parameters Y.Saw
        hxf(:,j,n) = h4d(:,1,n) * xf(1,j,n)
        DO i=2,nx+np !YSaw
          hxf(:,j,n) = hxf(:,j,n) +  h4d(:,i,n) * xf(i,j,n)
        END DO
      END DO
    END DO
    !
    ! hxfm = mean(H xf)
    !
    DO n=1,nwindow
      DO i=1,ny
        CALL com_mean(nbv,hxf(i,:,n),hxfm(i,n))
      END DO
    END DO
    !
    ! d = y - hxfm
    !
    d = y - hxfm
    !
    ! hdxf
    !
    DO n=1,nwindow
      DO i=1,nbv
        hdxf(:,i,n) = hxf(:,i,n) - hxfm(:,n)
      END DO
    END DO
    !
    ! LETKF
    !
    DO nn=1,nwindow
      DO ix=1,nx+np ! YSaw
        ny_loc = 0
        parm = parm_infl(ix,it+nn-1)
        DO n=1,nwindow
          tdif = REAL(ABS(nn-n),r_size)
          IF(tlocal < 0.0d0) tdif = 0.0d0
          DO i=1,ny
            DO j=1,nx+np ! Y.Saw state variables only
              IF(MAXVAL(h4d(i,:,n)) == h4d(i,j,n)) EXIT
            END DO
            ! model vs parameter spaces
            IF(j > nx) THEN
               jloc = j-nx
            ELSE
               jloc = j
            ENDIF
            IF(ix > nx) THEN
               ixloc = ix-nx
            ELSE
               ixloc = ix
            ENDIF
            !dist = REAL(MIN(ABS(j-ix),nx-ABS(j-ix)),r_size)
            dist = REAL(MIN(ABS(jloc-ixloc),nx-ABS(jloc-ixloc)),r_size)
            !PRINT*, 'localization ', dist, jloc, ixloc, j, ix, xmaxloc
            !IF(it < 100) dist = xmaxloc + 0.1 ! spinup
            IF(dist < xmaxloc) THEN
              ny_loc = ny_loc+1
              d_loc(ny_loc) = d(i,n)
              rdiag_loc(ny_loc) = obserr**2
              IF(msw_local == 0) THEN ! fixed localization
                rloc_loc(ny_loc) = EXP(-0.5 * (dist/xlocal)**2) &! space
                  & * EXP(-0.5 * (tdif/tlocal)**2) ! time
              ELSE ! adaptive localization
                CALL com_correl(nbv2,hdxf(i,1:nbv2,n),dxf(ix,1:nbv2,nn),obsloc(1))
                CALL com_correl(nbv-nbv2,hdxf(i,nbv2+1:nbv,n),dxf(ix,nbv2+1:nbv,nn),obsloc(2))
                CALL com_correl(nbv,hdxf(i,:,n),dxf(ix,:,nn),obsloc(3))
                wb = ABS(obsloc(3))
                wa = 1.0d0 - (0.5d0*ABS(obsloc(1)-obsloc(2)))
                rloc_loc(ny_loc) = wa**sa * wb**sb
                IF(msw_local == 2) THEN
                  rloc_loc(ny_loc) = rloc_loc(ny_loc) &
                  & * EXP(-0.5 * (dist/xlocal)**2) &! space
                  & * EXP(-0.5 * (tdif/tlocal)**2)  ! time
                END IF
              END IF
              hdxf_loc(ny_loc,:) = hdxf(i,:,n)
              IF(rloc_loc(ny_loc) < 0.0001d0) ny_loc = ny_loc-1
            END IF
          END DO
        END DO
        IF (ix > nx) THEN ! parameter already inflated by hoopeot
                 CALL letkf_core(nbv,ny*nwindow,ny_loc,hdxf_loc,rdiag_loc,rloc_loc,d_loc,parm_dummy,trans)
                 IF(msw_infl < 0.0d0) THEN ! Adaptive inflation
                         parms = 0.0d0
                         DO i=1,ny_loc
                                 parms(1) = parms(1) + d_loc(i)*d_loc(i)/rdiag_loc(i) * rloc_loc(i)
                         END DO
                         DO j=1,nbv
                                DO i=1,ny_loc
                                        parms(2) = parms(2) + hdxf_loc(i,j) * hdxf_loc(i,j) / rdiag_loc(i)
                                END DO
                         END DO
                         parms(2) = parms(2) / REAL(nbv-1,r_size)
                         parms(3) = SUM(rloc_loc(1:ny_loc))
                         parms(4) = (parms(1)-parms(3))/parms(2) - parm
                         !  sigma_o = 1.0d0/REAL(nobsl,r_size)/MAXVAL(rloc(1:nobsl))
                         sigma_o = 2.0d0/parms(3)*((parm*parms(2)+parms(3))/parms(2))**2
                         gain = 0.04d0**2 / (sigma_o + 0.04d0**2) !0.04d0 is a parameter
                         parm = parm + gain * parms(4)
                 ENDIF
        ELSE
                 CALL letkf_core(nbv,ny*nwindow,ny_loc,hdxf_loc,rdiag_loc,rloc_loc,d_loc,parm,trans)
        ENDIF
        !IF (RTPPInfl) THEN
        !        CALL letkf_core(nbv,ny*nwindow,ny_loc,hdxf_loc,rdiag_loc,rloc_loc,d_loc,parm_dummy,trans)
        !ELSE
        !        CALL letkf_core(nbv,ny*nwindow,ny_loc,hdxf_loc,rdiag_loc,rloc_loc,d_loc,parm,trans)
        !ENDIF
        IF(msw_infl > 0.0d0) THEN
                IF (ix > nx) THEN ! Different inflation factor for parameter and state
                        parm = msw_infl_para
                ELSE
                        parm = msw_infl
                ENDIF
        ENDIF 
        DO j=1,nbv
          xa(ix,j,nn) = xm(ix,nn)
          DO i=1,nbv
            xa(ix,j,nn) = xa(ix,j,nn) + dxf(ix,i,nn) * trans(i,j)
          END DO
        END DO
        !IF (RTPPInfl) THEN !posterior inflation by RTPP
        !    CALL com_mean(nbv,xa(ix,:,nn),xam(ix,nn)) !analysis mean before inflation
        !    DO j=1,nbv
        !       dxa(ix,j,nn) = xa(ix,j,nn) - xam(ix,nn)
        !       xa(ix,j,nn) = xam(ix,nn) + (1.0d0-parm)*dxa(ix,j,nn) + parm*dxf(ix,j,nn)
        !       !PRINT*,'RTPP', j, xam(ix,nn),parm,xa(ix,j,nn) 
        !    ENDDO
        !ENDIF
        !IF (ix > nx) THEN !parameter
        !    CALL hoopeot(xa(ix,:,nn), obs_para, obserr_para)
        !ENDIF
        !IF (it < 100) THEN ! spinup No data assimilation
        !  DO j = 1, nbv
        !    xa(ix,j,nn) = xf(ix,j,nn)
        !  ENDDO
        !ENDIF
        parm_infl(ix,it+nn) = parm
      END DO
    END DO
    !
    ! ensemble mean
    !
    DO n=1,nwindow
      DO i=1,nx+np
        CALL com_mean(nbv,xa(i,:,n),xm(i,n))
      END DO
    END DO
    !
    ! output analysis
    !
    IF(msw_detailout) THEN
      DO n=1,nwindow
        x4_long = xm(:,n)
        WRITE(91) x4_long
        IF(my_rank == 193) THEN
        DO i=1,nbv
          x4_long = xa(:,i,n)
          WRITE(93) x4_long
        END DO
        ENDIF
      END DO
    END IF
    !
    ! RMSE,SPRD
    !
    DO n=1,nwindow
      rmse_t(it+n-1) = SQRT(SUM((xm(1:nx,n)-xnature(:,it+n-1))**2)/REAL(nx,r_size))
      DO i=1,nx
        sprd_t(it+n-1) = sprd_t(it+n-1) + SUM((xa(i,:,n)-xm(i,n))**2)
      END DO
      sprd_t(it+n-1) = SQRT(sprd_t(it+n-1)/REAL(nx*nbv,r_size))
      infl_t(it+n-1) = SUM(parm_infl(:,it+n-1))/REAL(nx,r_size)
      IF(it > nspinup) THEN
        DO i=1,nx
          rmse_x(i) = rmse_x(i) + (xm(i,n)-xnature(i,it+n-1))**2
          sprd_x(i) = sprd_x(i) + SUM((xa(i,:,n)-xm(i,n))**2)/REAL(nbv,r_size)
          infl_x(i) = infl_x(i) + parm_infl(i,it+n-1)
        END DO
        irmse = irmse + 1
      END IF
    END DO
    !---------------
    ! forecast step
    !---------------
    DO i=1,nbv
      CALL tinteg_rk4_varyingF(ktcyc,xa(1:nx,i,nwindow),xa(nx+1:nx+np,i,nwindow),xf(1:nx,i,1))
      xf(nx+1:nx+np,i,1) = xa(nx+1:nx+np,i,nwindow) ! persistent for parameter Y.Saw
    END DO
    it = it+nwindow
    IF(it > nt) EXIT
  END DO
  !<<<
  !<<< LOOP END
  !<<<
  CLOSE(11)
  CLOSE(90)
  CLOSE(91)
  CLOSE(92)
  CLOSE(93)
  !OPEN(10,FILE='infl.dat',FORM='unformatted')
  !DO i=1,nt
  !  x4_long = REAL(parm_infl(:,i),r_sngl) ! Y.Saw
  !  WRITE(10) x4_long
  !END DO
  !CLOSE(10)

  !OPEN(10,FILE='rmse_t.dat',FORM='formatted')
  !DO i=1,nt
  !  WRITE(10,'(3F12.4)') REAL(i-1)/4.0,rmse_t(i),sprd_t(i)
  !END DO
  !CLOSE(10)

  rmse_x = SQRT(rmse_x / REAL(irmse,r_size))
  sprd_x = SQRT(sprd_x / REAL(irmse,r_size))
  !OPEN(10,FILE='rmse_x.dat',FORM='formatted')
  !DO i=1,nx
  !  WRITE(10,'(I4,2F12.4)') i,rmse_x(i),sprd_x(i)
  !END DO
  !CLOSE(10)

  rmseave = SUM(rmse_t(nspinup+1:nt))/REAL(nt-nspinup,r_size)
  sprdave = SUM(sprd_t(nspinup+1:nt))/REAL(nt-nspinup,r_size)
  inflave = SUM(infl_t(nspinup+1:nt))/REAL(nt-nspinup,r_size)
  PRINT '(A,F12.5)','RMSE = ',rmseave
  PRINT '(A,F12.5)','SPRD = ',sprdave
  PRINT '(A,F12.5)','INFL = ',inflave

  PRINT *, 'end at ', my_rank
  CALL MPI_Finalize(ierr)
  STOP
END PROGRAM letkf

SUBROUTINE hoopeot(theta_bk,theta_c,C_std,np,inflation)
!
! Sawada & Duc
! HOOPE-EnKF with optimal transport (1-D) version
!
  USE common
  USE common_letkf

  IMPLICIT NONE

  REAL(r_size),INTENT(INOUT):: theta_bk(np,nbv) !ensembles of parameter
  REAL(r_size),INTENT(IN)   :: theta_c          !climatological parameter
  REAL(r_size),INTENT(IN)   :: C_std            !climatological para's sd
  REAL(r_size),INTENT(IN)   :: inflation(np)    !prior MI hyperparameter
  REAL(r_size)              :: theta_g(np), theta_b(np), B_std(np), ptbmultip
  INTEGER, INTENT(IN)       :: np
  INTEGER :: i,j,k

  DO i = 1, np
     CALL com_mean(nbv, theta_bk(i,:), theta_b(i))
     CALL com_stdev(nbv, theta_bk(i,:), B_std(i))
  ENDDO
  !
  ! Posterior mean of theta after integrating N(theta_c,C_std**2)
  !
  DO i = 1, np
     theta_g(i) = theta_c*inflation(i)*(B_std(i)**2)/(C_std**2+inflation(i)*(B_std(i)**2)) + theta_b(i)*(C_std**2)/(C_std**2+inflation(i)*(B_std(i)**2))
  ENDDO
  !
  ! Calculating each ensembles
  !
  DO i = 1, np
   ptbmultip = C_std*inflation(i)**(1/2)/sqrt(C_std**2+inflation(i)*(B_std(i)**2))
   DO j = 1, nbv
     theta_bk(i,j) = theta_g(i) + ptbmultip*(theta_bk(i,j)-theta_b(i))
   ENDDO
  ENDDO

END SUBROUTINE


!SUBROUTINE hoopeot(theta_bk,theta_c,C_std)
!
! Sawada & Duc
! HOOPE-EnKF with optimal transport (1-D) version
!
  
!  USE common
!  USE common_letkf

!  IMPLICIT NONE

!  REAL(r_size),INTENT(INOUT):: theta_bk(nbv) !ensembles of parameter
!  REAL(r_size),INTENT(IN)   :: C_std             !climatological para's sd
!  REAL(r_size),INTENT(IN)   :: theta_c       !climatological parameter
!  REAL(r_size)              :: theta_g, theta_b, G, B, C
!  INTEGER :: i

!  CALL com_covar(nbv, theta_bk, theta_bk, B)   ! background
!  C = C_std**2  ! Climatology
!  G = (C**(-1)+B**(-1))**(-1)
!  CALL com_mean(nbv, theta_bk, theta_b)
!  theta_g = G*(theta_c * (C**(-1)) + theta_b * (B**(-1)))
!  DO i = 1, nbv
!     theta_bk(i) = theta_g + (B**(-1/2))*(((B**(1/2))*G*(B**(1/2)))**(1/2))*(B**(-1/2))*(theta_bk(i) - theta_b)
!  ENDDO
!END SUBROUTINE





