#
# Analyzing F and state variables in two-scale Lorenz96
# Mimicking Pathiraja and van Leeuwen 2022 JAMES
# Y.Sawada 20221220
#

from pylab import *
import numpy as np
import matplotlib.pyplot as plt
import numpy.ma as ma
import struct
from scipy.io import FortranFile

#
# configurations
#
xx = 18     # dimension
xx_nat = 9     # dimension
tt = 14399 # total time it should be 14400
nens = 40 # ensemble size
dataxa = np.zeros((tt,xx,nens))
datanat = np.zeros((tt,xx_nat))
datafor = np.zeros((tt,xx_nat))

f = FortranFile('../DATA/regular4/letkf_ens40_best/anal0026.dat','r')
for i in range(0,tt):
    for j in range(0,nens):
        dataxa[i,:,j] = f.read_reals(float32)
#    print(f.read_reals(float32))

#f = FortranFile('../DATA/regular4/test_onescale_F8_original/guesmean.dat','r')
f = FortranFile('../DATA/naturex.dat','r')
for i in range(0,tt):
    datanat[i,:] = f.read_reals(float32)

f = FortranFile('../DATA/force.dat','r')
for i in range(0,tt):
    datafor[i,:] = f.read_reals(float32)

fig=figure(figsize=(10,10))
targetgrid = 0
xaave = np.mean(dataxa[:,9+targetgrid,:],axis=1)
xastd = np.std(dataxa[:,9+targetgrid,:],axis=1)
#for i in range(0,nens):
#    plt.plot(dataxa[10000:10250,14,i])
plt.plot(datafor[10000:10250,targetgrid],'k')
plt.plot(xaave[10000:10250],color='red')
plt.plot(xaave[10000:10250]+xastd[10000:10250],color='grey',linestyle='--')
plt.plot(xaave[10000:10250]-xastd[10000:10250],color='grey',linestyle='--')
plt.xticks(fontsize=16)
plt.yticks(fontsize=16)
plt.ylim(0,25)
plt.xlabel('time',fontsize=16)
plt.ylabel('Fk',fontsize=16)
plt.savefig('letkf_f_optimal_ensemble.png')
plt.show()

#for i in range(0,nens):
#    plt.plot(dataxa[12000:12100,5,i])
#plt.plot(datanat[12000:12100,5],'--')
#plt.show()

#xaave = np.mean(dataxa[:,:,:],axis=2)
#plt.plot(xaave[12000:12500,14])
#plt.plot(datafor[12000:12500,5],'--')
#plt.show()

#plt.scatter(xaave[1000:,1],dataxa[1000:,8,0])
#plt.savefig('./force_x.png')
#plt.show()

