#
# Analyzing F and state variables in two-scale Lorenz96
# Mimicking Pathiraja and van Leeuwen 2022 JAMES
# Y.Sawada 20221220
#

from pylab import *
import numpy as np
import matplotlib.pyplot as plt
import numpy.ma as ma
import struct
from scipy.io import FortranFile

#
# configurations
#
xx = 18     # dimension
xx_nat = 9     # dimension
tt = 14399 # total time it should be 14400
dataxa = np.zeros((tt,xx))
datanat = np.zeros((tt,xx_nat))
datafor = np.zeros((tt,xx_nat))

#f = FortranFile('../DATA/regular4_hoope_AR/adaptive_hoope2/analmean000.dat','r')
#f = FortranFile('../DATA/regular4_pseudo_obs/hoope_pso_adaptive_ens40/analmean0000.dat','r')
#f = FortranFile('../DATA/regular4/hoope_rtc_adaptive_ens40/analmean0000.dat','r')
#f = FortranFile('../DATA/regular4_pseudo_obs/hoope_pso_adaptive_ens40/analmean0000.dat','r')
f = FortranFile('../DATA/regular4/letkf_adaptive_ens40/analmean0000.dat','r')
for i in range(0,tt):
    dataxa[i,:] = f.read_reals(float32)
#    print(f.read_reals(float32))

#f = FortranFile('../DATA/regular4/test_onescale_F8_original/guesmean.dat','r')
f = FortranFile('../DATA/naturex.dat','r')
for i in range(0,tt):
    datanat[i,:] = f.read_reals(float32)

f = FortranFile('../DATA/force.dat','r')
for i in range(0,tt):
    datafor[i,:] = f.read_reals(float32)

#plt.plot(dataxa[0,:])
#plt.show()



#levels = np.linspace(-10,15,10)
#plt.contourf(dataxa[10000:10500,0:9],vmin=-10,vmax=15,levels=levels)
#plt.imshow(dataxa[10000:10045,0:9],origin='lower',cmap=plt.cm.get_cmap("seismic",15),interpolation='nearest',vmin=-10,vmax=15)
#plt.colorbar()
#plt.savefig('letkf_para.png')
#plt.savefig('state_hoope.png')
#plt.show()

#plt.contourf(datanat[10000:10500,:],vmin=-10,vmax=15,levels=levels)
#plt.imshow(datanat[10000:10045,0:9],origin='lower',cmap=plt.cm.get_cmap("seismic",15),interpolation='nearest',vmin=-10,vmax=15)
#plt.colorbar()
#plt.savefig('nature.png')
#plt.savefig('state_nature.png')
#plt.show()

fig = plt.figure(figsize=(8,20))
levels = np.linspace(4,16,20)
plt.contourf(dataxa[10000:10250,9:],origin='lower',cmap=plt.cm.get_cmap("jet"),vmin=4,vmax=16,levels=levels,extend='both')
#fig.set_size_inches(5,20)
plt.colorbar()
plt.xticks(fontsize=16)
plt.yticks(fontsize=16)
plt.xlabel('Fk', fontsize=16)
plt.ylabel('time',fontsize=16)
plt.savefig('nohoope_f.png')
#plt.savefig('para_hoope.png')
plt.show()

fig = plt.figure(figsize=(8,20))
plt.contourf(datafor[10000:10250,:],origin='lower',vmin=4,vmax=16,cmap=plt.cm.get_cmap("jet"),levels=levels,extend='both')
plt.colorbar()
plt.xticks(fontsize=16)
plt.yticks(fontsize=16)
plt.xlabel('Fk', fontsize=16)
plt.ylabel('time',fontsize=16)
plt.savefig('nature_f.png')
#plt.savefig('para_nature.png')
plt.show()
#for i in range(9,18):
#    plt.plot(dataxa[0:5000,i])
#plt.plot(datafor[0:5000,7])
#plt.savefig('letkf_para_f_infl005.png')
#plt.show()

#plt.plot(dataxa[10000:10250,0])
#plt.plot(datanat[10000:10250,0])
#plt.savefig('state0_timeseries.png')
#plt.show()

#plt.plot(dataxa[10000:10250,12],'k')
#plt.plot(datafor[10000:10250,3],'r',linestyle='dashed')
#plt.ylim(2,21)
#plt.savefig('realrtc.png')

#plt.show()

#plt.scatter(datax[1000:,1],dataf[1000:,1])
#plt.savefig('./force_x.png')
##plt.show()

