#
# Analyzing F and state variables in two-scale Lorenz96
# Mimicking Pathiraja and van Leeuwen 2022 JAMES
# Y.Sawada 20221220
#

from pylab import *
import numpy as np
import matplotlib.pyplot as plt
import numpy.ma as ma
import struct
from scipy.io import FortranFile

#
# configurations
#
xx = 9     # dimension
tt = 14399 # total time it should be 14400
dataf = np.zeros((tt,xx))
datax = np.zeros((tt,xx))
datah = np.zeros((tt,xx+9))

f = FortranFile('../DATA/force.dat','r')
for i in range(0,tt):
    dataf[i,:] = f.read_reals(float32)
#    print(f.read_reals(float32))

f = FortranFile('../DATA/naturex.dat','r')
for i in range(0,tt):
    datax[i,:] = f.read_reals(float32)

#f = FortranFile('../DATA/regular4_hoope_AR/mpi_hoope2/analmean280.dat','r')
f = FortranFile('../DATA/regular4_pseudo_obs/hoope_pso_ens40/analmean0133.dat','r')
#f = FortranFile('../DATA/regular4/adaptive_letkf2_ens20/guesmean000.dat','r')
for i in range(0,tt):
    datah[i,:] = f.read_reals(float32)

plt.plot(datax[0,:])
plt.show()

plt.scatter(datax[5000:10000,1],datax[5000:10000,0],c=dataf[5001:10001,1],vmin=10,vmax=15,cmap=cm.rainbow)
plt.xlim(-10,15)
plt.ylim(-10,15)
plt.colorbar()
plt.xlabel('X[t]',fontsize=20)
plt.ylabel('X[t-6]',fontsize=20)
plt.savefig('attractor_nature.png')
plt.show()

plt.scatter(datah[5000:10000,1],datah[5000:10000,0],c=datah[5001:10001,10],vmin=10,vmax=15,cmap=cm.rainbow)
plt.xlim(-10,15)
plt.ylim(-10,15)
plt.colorbar()
plt.xlabel('X[t]',fontsize=20)
plt.ylabel('X[t-6]',fontsize=20)
plt.savefig('attractor_hoope.png')
plt.show()




