"""hybrid2D sub-pckage imports and metadata definitions."""

from hybrid2d import (
    Assembly_diffusion,
    FV_reference,
    Green,
    Metab_testing_module,
    Module_Coupling,
    Module_Coupling_sparse,
    Neighbourhood,
    Reconstruction_extended_space,
    Reconstruction_functions,
    Small_functions,
    Testing,
    reconst_and_test_module,
)

try:
    from hybrid2d._version import version as ver  # pylint: disable=E0401,E0611

    __version__ = ver
    del ver
except ModuleNotFoundError:
    try:
        from importlib.metadata import PackageNotFoundError, version  # pragma: no cover

        __version__ = version(__name__)
    except PackageNotFoundError:  # pragma: no cover
        __version__ = "unknown"
    finally:
        del version, PackageNotFoundError
