#!/usr/bin/env python
# coding: utf-8

# In[7]:


# Define Computer
import os

import matplotlib.pylab as pylab
import matplotlib.pyplot as plt
import numpy as np
import pandas as pd

params = {
    "legend.fontsize": "x-large",
    "figure.figsize": (10, 10),
    "axes.labelsize": "x-large",
    "axes.titlesize": "x-large",
    "xtick.labelsize": "x-large",
    "ytick.labelsize": "x-large",
    "font.size": 24,
    "lines.linewidth": 2,
    "lines.markersize": 15,
}
pylab.rcParams.update(params)

plt.style="classic"
csv_directory = os.path.dirname(__file__)


solubility = 1.39e-6  # mumol mm^-3 mmHg^-1
Pmax = 60  # mmHg
D_real = 2e-3  # mm^2 s^-1

alpha_Pmax_D = 1.39e-6 * Pmax * 2e-3
alpha_Pmax_D_mumol_cm_min = alpha_Pmax_D * 6e10

#Since we have an array of 20 densities and only 4 layers, we assign a value of density to each layer
density_layer=np.array([0,5,10,17])

# In[8]:


density_range = np.squeeze(np.array(pd.read_csv(csv_directory + "/density_range.csv")))
L, L_char, solubility, P_plateau, D, R_art = np.squeeze(
    np.array(pd.read_csv(csv_directory + "/parameters.csv"))
)
Da_t_range = np.squeeze(np.array(pd.read_csv(csv_directory + "/Da_t_range.csv")))
mean_range = np.squeeze(np.array(pd.read_csv(csv_directory + "/mean_range.csv")))

#%% - This loop is to store the values of the plateau, the standard deiation and others on their 
# respective arrays 

plat = np.zeros((len(Da_t_range), len(mean_range), len(density_range)))
std_plat = np.zeros((len(Da_t_range), len(mean_range), len(density_range)))
full_plat = np.zeros((len(Da_t_range), len(mean_range), len(density_range), 30))


#%% - In this section we do the box plots

# =============================================================================
# The purpose here is to show the evolution of the average concentration in the capillary 
# bed through the use of a box plot. The idea is to have the evolution for four values of 
# capillary concentration by varying the density. We choose a fixed value for the metabolism
# =============================================================================

from scipy.stats import linregress
j=4 #Dictates the value of hte metabolism 
color_pallete= [  '#C0C0C0', '#90EE90',   '#E6E6FA','#ADD8E6' ,'#00CED1']
darker_colors = ['#808080', '#58b258', '#b8b0dc', '#82b0cf', '#00858a']
colors=['#1f77b4', '#2ca02c', '#d62728', '#ff7f0e', '#00858a']




#%%


k=1 #We focus on the second layer
Da=np.array([20,30,40,60])
plat=np.zeros(len(Da))
std_plat=np.zeros(len(Da))

M_array=alpha_Pmax_D_mumol_cm_min*Da/100/L_char**2
cc=-1
for j in Da:
    cc+=1
    i=density_layer[k]
    mean, Da, layer = mean_range[k], j/100, k

    filename = (
        csv_directory + "/metab_{}".format(j) + "/dens_{}_mean_{}_".format(i, k)
    )

    array_avg = np.load(filename + "avg.npy")
    std_avg = np.std(array_avg, axis=0)
    p = np.load(filename + "plateau.npy")

    plat[cc] = np.sum(p) / len(p)
    std_plat[cc] = np.std(p)

    total_avg = np.sum(array_avg, axis=0) / array_avg.shape[0]
    label_string = "M=%.2f $\dfrac{\mu mol}{cm^3 min}$" % (
        j/100 / L_char**2 * alpha_Pmax_D_mumol_cm_min
    )
    plt.plot(
        np.linspace(0, L / 2, 100),
        np.sum(array_avg, axis=0) / array_avg.shape[0],
        label=label_string, color=colors[cc],
    )
    plt.fill_between(
        np.linspace(0, L / 2, 100),
        total_avg - std_avg / 2,
        total_avg + std_avg / 2,
        alpha=0.3,
        color=colors[cc]
    )

plt.ylim(0.15, 1.1)
# =============================================================================
# box_string = "M=%.2f $\dfrac{\mu mol}{cm^3 min}$" % (
#     Da_t_range[j] / L_char**2 * alpha_Pmax_D_mumol_cm_min
# )
# plt.text(90, 0.60, box_string, fontsize=20,
#          bbox=dict(facecolor="white", alpha=0.5))
# =============================================================================

if k==0:
    tit_str='Layer I'
if k==1:
    tit_str='Layer II'
if k==2:
    tit_str='Layer III'
if k==3:
    tit_str='Layer IV'
    
plt.legend(fontsize="small")
plt.title(tit_str)


exp1=np.array(pd.read_csv(csv_directory + '/Exp_data1.txt', header=None))
exp2=np.array(pd.read_csv(csv_directory + '/Exp_data2.txt', header=None))

# First attempt
radial_prof_x=(exp2[9,:]+exp2[10,:]+exp2[11,:]+exp2[12,:])/4
radial_prof_y=(exp2[:,9]+exp2[:,10]+exp2[:,11]+exp2[:,8])/4

radial_prof_x=radial_prof_x[10:-1]/2+radial_prof_x[1:10][::-1]/2
radial_prof_y=radial_prof_y[11:]/2+radial_prof_y[2:11][::-1]/2

radial_prof_id=(exp2[9,:]+exp2[10,:]+exp2[11,:])/3

#plt.plot(np.linspace(0,200,10),(radial_prof_id[:10][::-1]/48+radial_prof_id[10:]/48)/2, linestyle='--', linewidth=5, color='k')
processed=radial_prof_x/2+radial_prof_y/2
plt.plot(np.linspace(0,200,10)[:-1],processed/np.max(processed), linestyle='--', linewidth=5, color='k')
plt.scatter(np.linspace(0,200,10)[:-1],processed/np.max(processed), marker='x' ,s=300, color='k')
plt.xlabel('Distance from arteriole\'s center \n [$\mu$m]')
plt.ylabel('$\dfrac{\langle \phi \\rangle}{\phi_{PA}}$', rotation=0, labelpad=40)
plt.tight_layout()
plt.savefig('/home/pdavid/Bureau/Code/OxyBrain/Figures_and_Tests/FigS5/Layers/Layer_{}.pdf'.format(k+1))
plt.show()


# In[73]: - Figure - Density
