#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Mon Feb 14 11:18:37 2022

@author: pdavid

SCRIPT FOR THE SINGLE SOURCE AND TO EVALUATE THE NON LINEAR MODEL on a centered position with
both Dirichlet and periodic BCs

"""
# djkflmjaze
import os

import matplotlib.pylab as pylab

params = {
    "legend.fontsize": "x-large",
    "figure.figsize": (12, 12),
    "axes.labelsize": "x-large",
    "axes.titlesize": "x-large",
    "xtick.labelsize": "x-large",
    "ytick.labelsize": "x-large",
    "font.size": 18,
    "lines.linewidth": 4,
}
pylab.rcParams.update(params)
# Define Computer

directory_script = os.path.dirname(__file__)
with open(os.path.join(directory_script,'../../current_directory.txt'), 'r') as file:
    file_contents = file.read()
# Now, file_contents contains the entire content of the file as a string

source_directory=os.path.join(file_contents[:-1], 'src')
import sys
sys.path.append(source_directory)


script = os.path.abspath(sys.argv[0])
directory_script = os.path.dirname(script)
name_script = script[script.rfind("/") + 1 : -3]
csv_directory = os.path.join(directory_script, "Layers")
os.makedirs(csv_directory, exist_ok=True)

print(csv_directory)


import math

import matplotlib.pylab as pylab
import numpy as np
import pandas as pd

from Metab_testing_module import metab_simulation
from Testing import save_csv

params = {
    "legend.fontsize": "x-large",
    "figure.figsize": (6, 6),
    "axes.labelsize": "x-large",
    "axes.titlesize": "x-large",
    "xtick.labelsize": "x-large",
    "ytick.labelsize": "x-large",
    "text.usetex": False,
}
pylab.rcParams.update(params)


simulation = 1


solubility = 1.39e-6  # mumol mm^-3 mmHg^-1
Pmax = 60  # mmHg
D_real = 2e-3  # mm^2 s^-1

alpha_Pmax_D = 1.39e-6 * Pmax * 2e-3
alpha_Pmax_D_mumol_cm_min = alpha_Pmax_D * 6e10


#%% - Do the analysis per angle


L = 400  # According to the experimental data
alpha = 20
R_art = L / alpha
R_cap = R_art / 10
K_eff = math.inf
directness = 10


# =============================================================================
# Da_t_range=np.linspace(0,Da_t_max,6)
# save_csv(csv_directory + '/Da_t_range.csv', ['Da_t_range'],Da_t_range)
# =============================================================================

Da_t_range = np.squeeze(np.array(pd.read_csv(csv_directory + "/Da_t_range.csv")))


# =============================================================================
# mean_range=np.array([0.4,0.45,0.5,0.55])
# save_csv(csv_directory+'/mean_range.csv', ['mean_range'], mean_range)
# =============================================================================

mean_range = np.squeeze(np.array(pd.read_csv(csv_directory + "/mean_range.csv")))

# =============================================================================
# L_char=50 #micrometers
# solubility= 1.39e-6 #micromol/(mm3*mmHg)
# P_max=40 #mmHg
# D=4e-3 #mm2/s
# save_csv(csv_directory + '/parameters.csv', ['parameters'],np.array([L,L_char, solubility, P_max, D, alpha]))
# =============================================================================

L, L_char, solubility, P_max, D, alpha = np.squeeze(
    np.array(pd.read_csv(csv_directory + "/parameters.csv"))
)
real_metab = (
    Da_t_range * alpha_Pmax_D_mumol_cm_min / L_char**2
)  # in \mu mol cm^-3 min^-1

Prop_Da_M = P_max * D * solubility / L_char**2
M_values = Da_t_range * Prop_Da_M

M_values_min = Da_t_range * 5.3376

couche = np.linspace(352, 528, 4)

density_range = np.concatenate(([250], np.linspace(352, 528, 4)))
density_range = np.linspace(350, 550, 20)

save_csv(csv_directory + "/density_range.csv", ["density"], density_range)

density_range = np.squeeze(np.array(pd.read_csv(csv_directory + "/density_range.csv")))


#%%

r = np.linspace(0, L / 2, 100)
c = 0
for Da in Da_t_range:
    os.makedirs(csv_directory + "/metab_{}".format(int(c)), exist_ok=True)
    c += 1


def execute_simulation_real_plateau(damkohler):

    L, L_char, solubility, P_max, D, alpha = np.squeeze(
        np.array(pd.read_csv(csv_directory + "/parameters.csv"))
    )
    L / alpha
    K_eff = math.inf
    directness = 10
    simulations = 10
    measures = 10
    std = 0.1

    # BC_type=np.array(["Infinite","Infinite","Infinite", "Infinite"])
    BC_type = np.array(["Periodic", "Periodic", "Periodic", "Periodic"])
    BC_value = np.zeros(4)
    Da_t_range = np.squeeze(np.array(pd.read_csv(csv_directory + "/Da_t_range.csv")))

    mean_range = np.squeeze(np.array(pd.read_csv(csv_directory + "/mean_range.csv")))

    for layer in np.array([1,2,3]): #loop through each layer
        density_position_this_layer=np.array([ 0,  5, 10, 17])[layer]
        
        mean = mean_range[layer]
        current_dir = os.path.join(csv_directory, "metab_{}".format(int(damkohler*100)))
        os.makedirs(current_dir, exist_ok=True)
        Da = damkohler
        M = Da / L_char**2


        density = density_range[density_position_this_layer]

        a, b, c = metab_simulation(
            mean,
            std,
            simulations,
            density,
            L,
            L / 4,
            L / alpha,
            3,
            K_eff,
            directness,
            M,
            0.1,
            measures,
            BC_type,
            BC_value,
        )

        np.save(current_dir + "/dens_{}_mean_{}_avg".format(int(density_position_this_layer), layer), a)
        np.save(current_dir + "/dens_{}_mean_{}_plateau".format(int(density_position_this_layer), layer), b)
        np.save(current_dir + "/dens_{}_mean_{}_q".format(int(density_position_this_layer), layer), c)


#execute_simulation_real_plateau(16)

import math

#%%
from multiprocessing import Pool

if __name__ == "__main__":
    import pdb
    with Pool() as pool:
        #result = pool.map(execute_simulation_real_plateau, np.arange(20))
        # result = pool.map(execute_simulation_real_plateau, np.array([12,13,14,15,16,17,18,19]))
        result = pool.map(execute_simulation_real_plateau, Da_t_range)
    print("Program finished!")
