#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Mon Feb 14 11:18:37 2022

@author: pdavid

SCRIPT TO PERFORM THE RELEVANT SIMULATIONS TO LATER ANALYZE THE PERIARTERIOLAR 


"""
# djkflmjaze
import os

import matplotlib.pylab as pylab
import matplotlib.pyplot as plt
params = {
    "legend.fontsize": "x-large",
    "figure.figsize": (12, 12),
    "axes.labelsize": "x-large",
    "axes.titlesize": "x-large",
    "xtick.labelsize": "x-large",
    "ytick.labelsize": "x-large",
    "font.size": 18,
    "lines.linewidth": 4,
}

pylab.rcParams.update(params)
# Define Computer
import matplotlib as mpl
mpl.style.use('classic')

directory_script = os.path.dirname(__file__)
csv_directory = os.path.join(directory_script, "csv_outputs")
with open(os.path.join(directory_script,'../../current_directory.txt'), 'r') as file:
    file_contents = file.read()
# Now, file_contents contains the entire content of the file as a string

source_directory=os.path.join(file_contents[:-1], 'src')
import sys
sys.path.append(source_directory)


script = os.path.abspath(sys.argv[0])
directory_script = os.path.dirname(script)
name_script = script[script.rfind("/") + 1 : -3]
csv_directory = os.path.join(directory_script)
os.makedirs(csv_directory, exist_ok=True)

import pdb
from Reconstruction_functions import get_average_rapid
import math

import matplotlib.pylab as pylab
import numpy as np
import pandas as pd

from Metab_testing_module import metab_simulation
from Testing import save_csv
from Reconstruction_extended_space import reconstruction_extended_space
from Metab_testing_module import position_sources
import random
from Testing import Testing
from Small_functions import plot_sketch


params = {
    "legend.fontsize": "x-large",
    "figure.figsize": (6, 6),
    "axes.labelsize": "x-large",
    "axes.titlesize": "x-large",
    "xtick.labelsize": "x-large",
    "ytick.labelsize": "x-large",
    "text.usetex": False,
}
pylab.rcParams.update(params)




Da_t_range = np.squeeze(np.array(pd.read_csv(csv_directory + "/Da_t_range.csv")))

mean_range = np.squeeze(np.array(pd.read_csv(csv_directory + "/mean_range.csv")))

L, L_char, solubility, P_max, D, alpha = np.squeeze(
    np.array(pd.read_csv(csv_directory + "/parameters.csv"))
)

R_art=L/alpha
R_cap=4.8

alpha_Pmax_D = solubility * P_max * D
alpha_Pmax_D_mumol_cm_min = alpha_Pmax_D * 6e10
Prop_Da_M = alpha_Pmax_D_mumol_cm_min/L_char**2
real_metab = (
    Da_t_range * Prop_Da_M
)  # in \mu mol cm^-3 min^-1




couche = np.linspace(352, 528, 4)

density_range = np.concatenate(([250], np.linspace(352, 528, 4)))
density_range = np.linspace(350, 550, 20)

save_csv(csv_directory + "/density_range.csv", ["density"], density_range)

density_range = np.squeeze(np.array(pd.read_csv(csv_directory + "/density_range.csv")))
#%%
import json
r = np.linspace(0, L / 2, 100)
c = 0
for Da in Da_t_range:
    os.makedirs(csv_directory + "/metab_{}".format(int(c)), exist_ok=True)
    c += 1

def execute_simulation_cool_plots(dens_pos):
    """What do we want to do here?
    
    This is for individual plots 
    """
    directness = 10
    std = 0.1
    # BC_type=np.array(["Infinite","Infinite","Infinite", "Infinite"])
    BC_type = np.array(["Periodic", "Periodic", "Periodic", "Periodic"])
    BC_value = np.zeros(4)
    k = dens_pos
    cc = 0
    print(k)
    int(k)
    density = density_range[k]
    #Try to do the same source positioning 
    pos_s = np.array([[0.5, 0.5]]) * L
    pos_s = np.concatenate((pos_s, position_sources(density, L, L / 4)), axis=0)
    S = len(pos_s)
    


    if np.any(pos_s > L) or np.any(pos_s < 0):
        print("ERROR IN THE POSITIONING")
    
    #for j in range(len(mean_range)):
    for j in [0,1,3]:
        
        mean = mean_range[j]
        Rv = np.array([R_art])
        C_v_array = np.array([1])
        for kk in range(S - 1):
            C_v_array = np.append(C_v_array, random.gauss(mean, std))
            Rv = np.append(Rv, R_cap)
        #for i in np.array([0, len(Da_t_range)-1]):
        for i in np.array([len(Da_t_range)-1]):
            current_dir = os.path.join(csv_directory, "metab_{}".format(int(cc)))
            os.makedirs(current_dir, exist_ok=True)
            Da = Da_t_range[i]
            M = Da / L_char**2
            K_eff=math.inf
            
            cells = 20
            D = 1
            ratio = 10
            # BC_type = np.array(["Infinite", "Infinite", "Infinite", "Infinite"])
            
            h_coarse = L / cells
            x_coarse = np.linspace(
                h_coarse / 2, L - h_coarse / 2, int(np.around(L / h_coarse))
            )
            y_coarse = x_coarse
            t = Testing(
                pos_s,
                Rv,
                cells,
                L,
                K_eff,
                D,
                directness,
                ratio,
                C_v_array,
                BC_type,
                BC_value,
            )
            
            print("CMRO2= ", M)
            
            plot_sketch(x_coarse, y_coarse, directness, h_coarse, pos_s, L, os.getcwd())
            C_v_array[C_v_array > 1] = 1
            C_v_array[C_v_array < 0] = 0
            Multi_FV_metab, Multi_q_metab = t.Multi(M, 0.1)
            phi , _,_=t.Reconstruct_Multi(1,0)
            
            a, b = get_average_rapid(
                Multi_FV_metab,
                Multi_q_metab,
                directness,
                t.pos_s,
                t.n.x,
                t.n.y,
                t.s_blocks,
                t.Rv,
                t.n.h,
                C_v_array,
                K_eff,
                D,
            )
            phi_coarse = a + b
            # Create a 2x3 subplot grid
            fig, axs = plt.subplots(2, 3, figsize=(22, 12))
            # Subplot 1
            im1=axs[0, 0].imshow(phi, vmax=1, vmin=0, extent=[0,L,0,L])
            #axs[0, 0].set_xlabel('X Label 1')
            axs[0, 0].set_ylabel('Y')
            axs[0, 0].set_title('Fine $\phi$ field')
            plt.colorbar(im1,ax=axs[0, 0], shrink=0.9)
            
            # Subplot 2
            im2=axs[1, 0].imshow(phi_coarse.reshape(cells,cells), vmax=1, vmin=0,extent=[0,L,0,L])
            #axs[1, 0].set_xlabel('X Label 2')
            axs[1, 0].set_ylabel('Y')
            axs[1, 0].set_title('Coarse $\phi$ field')
            plt.colorbar(im2,ax=axs[1, 0], shrink=0.9)
            
# =============================================================================
#             theta=np.linspace(0, 2*np.pi*(19/20), 20)
#             FEM_x=np.linspace(0, L/2, 20)
#             phi_theta=np.zeros((20,20))
#             for ii in range(20):
#                 phi_kk , _,_=t.Reconstruct_Multi(1,0, FEM_x*np.cos(ii)+L/2, FEM_x*np.sin(ii)+L/2)
#                 phi_kk[FEM_x<R_art]=1
#                 phi_theta[ii]=phi_kk
#             axs[0, 2].plot(FEM_x, np.sum(phi_theta, axis=0)/20)
#             axs[0, 2].set_xlabel('X Label 4')
#             axs[0, 2].set_ylabel('Y Label 4')
#             axs[0, 2].set_title('Title 4')
# =============================================================================
            
            met=(phi/(phi+0.1)).reshape(cells*ratio,cells*ratio)
            im3=axs[0, 1].imshow(met, interpolation='bicubic', vmax=1, vmin=0.4)
            axs[0,1].set_xlabel('X ')
            axs[0,1].set_ylabel('Y ')
            axs[0,1].set_title('Title 3')
            plt.colorbar(im3,ax=axs[0,1], shrink=0.9)
            
            # Subplot 3
            met_coarse=(phi_coarse/(phi_coarse+0.1)).reshape(cells,cells)
            im3=axs[1,1].imshow(met_coarse, interpolation='bicubic', vmax=1, vmin=0.4)
            axs[1,1].set_xlabel('X ')
            axs[1,1].set_ylabel('Y ')
            axs[1,1].set_title('Title 3')
            plt.colorbar(im3,ax=axs[1,1], shrink=0.9)
            
            
            # Subplot 5
            im5=axs[1, 2].imshow(met*Da_t_range[i]*Prop_Da_M, interpolation='bicubic', vmax=np.max(met)*Da_t_range[i]*Prop_Da_M, vmin=np.min(met)*Da_t_range[i]*Prop_Da_M)
            axs[1, 2].set_xlabel('X Label 4')
            axs[1, 2].set_ylabel('Y Label 4')
            axs[1, 2].set_title('Title 4')
            plt.colorbar(im5,ax=axs[1,2], shrink=0.9)
            
                        # Subplot 5
            im5=axs[0, 2].imshow(met_coarse*Da_t_range[i]*Prop_Da_M, interpolation='bicubic', vmax=np.max(met_coarse)*Da_t_range[i]*Prop_Da_M, vmin=np.min(met_coarse)*Da_t_range[i]*Prop_Da_M)
            axs[0, 2].set_xlabel('X Label 4')
            axs[0, 2].set_ylabel('Y Label 4')
            axs[0, 2].set_title('Title 4')
            plt.colorbar(im5,ax=axs[0,2], shrink=0.9)
            
            # Adjust layout for better spacing
            plt.tight_layout()
            directory=csv_directory + "/data_figures/Da{}".format(i)
            os.makedirs(directory, exist_ok=True)
            plt.savefig(directory+"/dens_{}_mean_{}.pdf".format(dens_pos//4+1, int(mean*100)))
            # Show the plot
            plt.show()
            
            file=directory+"/dens_{}_mean_{}.json"
            with open(file, 'w') as f:
                # indent=2 is not needed but makes the file human-readable 
                # if the data is nested
                json.dump([phi.tolist(), 
                           phi_coarse.tolist(), 
                           met.tolist(), 
                           met_coarse.tolist(), 
                           Da_t_range.tolist(), 
                           Prop_Da_M.tolist()], f, indent=2) 
            pdb.set_trace()


#%%


#%%
#execute_simulation_cool_plots(0)
execute_simulation_cool_plots(5)
import math
with open("file.json", 'r') as f:
    score = json.load(f)
#%%
from multiprocessing import Pool

if __name__ == "__main__":
    with Pool() as pool:
        #result = pool.map(execute_simulation_real_plateau, np.arange(20))
        # result = pool.map(execute_simulation_real_plateau, np.array([12,13,14,15,16,17,18,19]))
        result = pool.map(execute_simulation_cool_plots, np.array([ 0,  5, 17]))
        #result = pool.map(execute_simulation_cool_plots, np.array([ 0,  5, 10, 17]))
    print("Program finished!")
