#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Thu Mar 23 11:01:05 2023

@author: pdavid

This file is intended to use for the first time the Metab_testing_module_class to do experiments
to research the influence of the metabolism and the  capillary bed on perivascular gradients

"""

import os

import matplotlib.pylab as pylab

# djkflmjaze
import matplotlib.pyplot as plt

params = {
    "legend.fontsize": "x-large",
    "figure.figsize": (12,13),
    "axes.labelsize": "x-large",
    "axes.titlesize": "x-large",
    "xtick.labelsize": "x-large",
    "ytick.labelsize": "x-large",
    "font.size": 28,
    "lines.linewidth": 4,
}
pylab.rcParams.update(params)
# Define Computer

import matplotlib.style
import matplotlib as mpl
mpl.style.use('classic')

import math
import os

directory_script = os.path.dirname(__file__)
csv_directory = os.path.join(directory_script, "csv_outputs")
with open(os.path.join(directory_script,'../../current_directory.txt'), 'r') as file:
    file_contents = file.read()
# Now, file_contents contains the entire content of the file as a string

source_directory=os.path.join(file_contents[:-1], 'src')
import sys
sys.path.append(source_directory)

import matplotlib.pylab as pylab
import matplotlib.pyplot as plt
import numpy as np
import pandas as pd

from Small_functions import plot_sketch
from Testing import Testing

#%%

script = os.path.abspath(sys.argv[0])
directory_script = os.path.dirname(script)
name_script = script[script.rfind("/") + 1 : -3]
params_dir = os.path.join(directory_script, "Smooth_density")
os.makedirs(params_dir, exist_ok=True)

save_directory = os.path.join(directory_script, "Fig7")


density_range = np.squeeze(np.array(pd.read_csv(params_dir + "/density_range.csv")))
L, L_char, solubility, P_plateau, D, R_art = np.squeeze(
    np.array(pd.read_csv(params_dir + "/parameters.csv"))
)
Da_t_range = np.squeeze(np.array(pd.read_csv(params_dir + "/Da_t_range.csv")))
mean_range = np.squeeze(np.array(pd.read_csv(params_dir + "/mean_range.csv")))
cells = 20
measures = 30
std_dev = 0.1
R_cap = R_art / 4
phi_0 = 0.1
BC_type = np.array(["Infinite", "Infinite", "Infinite", "Infinite"])
BC_type = np.array(["Periodic", "Periodic", "Periodic", "Periodic"])
BC_value = np.zeros(4)

#%%

j=1

mean = mean_range[1]
density = density_range[1]
cyl_rad = L / 4
directness = 20

solubility = 1.39e-6  # mumol mm^-3 mmHg^-1
Pmax = 60  # mmHg
D_real = 2e-3  # mm^2 s^-1

alpha_Pmax_D = 1.39e-6 * Pmax * 2e-3
alpha_Pmax_D_mumol_cm_min = alpha_Pmax_D * 6e10

CMRO2_max = Da_t_range[j] / L_char**2
CMRO2_max_real = CMRO2_max * alpha_Pmax_D_mumol_cm_min
print("Real CMRO2={} micromol min^-1 cm^-3".format(CMRO2_max_real))
D = 1

# From the article, the colorbar

vmax = 58
vmin = 15

#%%
pos_s = np.array(
    [
        [200.0, 200.0],
        [23.87047349, 40.89122807],
        [24.45887178, 67.51894578],
        [48.04944283, 135.97819502],
        [28.94234373, 187.92956011],
        [8.00554588, 279.61934914],
        [21.6819244, 306.97897297],
        [21.16618053, 349.14811684],
        [80.71986303, 18.47551705],
        [87.35335842, 75.07341955],
        [91.23257687, 126.3786223],
        [93.82457015, 189.87894023],
        [77.53278571, 254.29719199],
        [76.30222889, 309.92952057],
        [81.77720812, 394.09359373],
        [136.74698722, 23.51670243],
        [133.14931692, 80.41102371],
        [156.90226814, 311.87607909],
        [139.12305707, 369.53207041],
        [196.39123561, 20.42135332],
        [193.27467552, 98.50308366],
        [193.02986569, 313.28750763],
        [220.39718322, 356.04565965],
        [269.59297839, 42.10380989],
        [241.08500709, 99.89982819],
        [246.36926763, 306.22384963],
        [238.97516388, 376.87013225],
        [304.5655837, 20.00012644],
        [298.97551693, 84.84472952],
        [300.04654808, 155.54132207],
        [313.44202004, 190.31471847],
        [315.57895906, 237.7928412],
        [334.49601379, 303.67462089],
        [300.00212461, 355.08998596],
        [369.08177569, 33.28149992],
        [368.52924452, 86.46402956],
        [372.41921654, 131.18528988],
        [389.13068548, 187.40323785],
        [363.8153435, 260.26677555],
        [369.14500088, 319.15970195],
        [392.87832762, 383.95489229],
    ]
)

C_v_array = (
    np.array(
        [
            1.0,
            0.57246213,
            0.50571741,
            0.49592569,
            0.55338121,
            0.47267549,
            0.46980048,
            0.33237617,
            0.42681366,
            0.53220625,
            0.45553307,
            0.36204203,
            0.58325151,
            0.59289267,
            0.4005591,
            0.83343293,
            0.55276502,
            0.50106695,
            0.52790288,
            0.54230654,
            0.49895431,
            0.52972563,
            0.52067013,
            0.43936351,
            0.3959371,
            0.43058031,
            0.39869534,
            0.45432741,
            0.53624378,
            0.43328199,
            0.33622388,
            0.74825387,
            0.30765414,
            0.47552855,
            0.5200606,
            0.52011616,
            0.56780783,
            0.46229349,
            0.53003323,
            0.45486517,
            0.36133643,
        ]
    )
    - 0.05
)

C_v_array[0] = 1

S = len(pos_s)
Rv = np.array([R_art])
Rv = np.concatenate((Rv, np.zeros(len(C_v_array) - 1) + R_art / 4))
#%%
h_coarse = L / cells
x_coarse = np.linspace(h_coarse / 2, L - h_coarse / 2, int(np.around(L / h_coarse)))
y_coarse = x_coarse
plt.rcParams["font.size"] = 38
plt.rcParams["figure.figsize"] = (12, 13)
plot_sketch(x_coarse, y_coarse, directness, h_coarse, pos_s, L, save_directory)
C_v_array[C_v_array > 1] = 1
C_v_array[C_v_array < 0] = 0
#%%
t = Testing(
    pos_s,
    Rv,
    cells,
    L,
    math.inf + np.zeros(len(C_v_array)),
    D,
    directness,
    1,
    C_v_array,
    BC_type,
    BC_value,
)
Multi_s_metab, Multi_q_metab = t.Multi(CMRO2_max, phi_0)

#%%
from Reconstruction_functions import get_average_rapid

a, b = get_average_rapid(
    Multi_s_metab,
    Multi_q_metab,
    directness,
    pos_s,
    t.n.x,
    t.n.y,
    t.s_blocks,
    t.Rv,
    t.n.h,
    C_v_array,
    t.K_eff,
    D,
)
phi_coarse = a + b

t.ratio = 8
c = t.Reconstruct_Multi(1, 0)
#%% - Reconstruct average value of the concentration within each FV cell


plt.imshow(
    (a + b) * Pmax,
    origin="lower",
    extent=(0, L, 0, L),
    vmin=vmin,
    vmax=vmax,
    interpolation="nearest",
)
plt.colorbar()
plt.xlabel("x ($\mu m$)")
plt.ylabel("y ($\mu m$)")
plt.title("Reconstruction $\phi$")
plt.savefig(os.path.join(save_directory, "experimental_avg.svg"))
plt.show()


#%% - Reconstruct value of the concentration field at the FV cells centers
plt.imshow(
    (t.Multi_metab_object.s_FV_metab + t.n.rec_sing).reshape(cells, cells) * 60,
    origin="lower",
    extent=(0, L, 0, L),
    vmin=15,
    vmax=58,
    interpolation="nearest",
)
plt.colorbar()
plt.xlabel("x ($\mu m$)")
plt.ylabel("y ($\mu m$)")
plt.title("$\phi$")
# plt.savefig(os.path.join(save_directory, 'experimental_centers.svg'))
plt.show()

#%% - Reconstruction metabolism
# Define Computer
plt.style.use(['classic'])
pylab.rcParams.update(params)
CMRO_map=CMRO2_max_real * (phi_coarse / (phi_coarse + phi_0)).reshape(cells, cells)
plt.imshow(
    CMRO_map,
    origin="lower",
    vmin=1.1,
    vmax=np.max(CMRO_map)+0.2,
    extent=(0, L, 0, L),
    interpolation="bicubic",
)
plt.xlabel("x ($\mu m$)")
plt.ylabel("y ($\mu m$)")
plt.colorbar()

plt.title("Metabolism")
plt.savefig(os.path.join(save_directory, "experimental_metab.svg"))
plt.show()

#%% - Fine sub grid reconstruction of the concentration field
plt.imshow(c[0] * Pmax, origin="lower", extent=(0, L, 0, L), vmin=vmin, vmax=vmax)
plt.xlabel("x ($\mu m$)")
plt.ylabel("y ($\mu m$)")
plt.colorbar()
plt.title("$\phi$")
plt.savefig(os.path.join(save_directory, "Rec_fine_phi.svg"))
plt.show()
#%%
# =============================================================================
# plt.style.use('classic')
# plt.imshow(a[0].reshape(m.t.ratio*cells, m.t.ratio*cells), origin='lower',extent=(0,L,0,L), interpolation='bilinear')
# plt.xlabel('x ($\mu m$)')
# plt.ylabel('y ($\mu m$)')
# plt.title("$\phi$")
# plt.colorbar()
# plt.show()
# #%%
# plt.style.use('default')
# plt.imshow(1-phi_0/(a[0].reshape(m.t.ratio*cells, m.t.ratio*cells)+phi_0), origin='lower',extent=(0,L,0,L), interpolation='nearest')
# plt.xlabel('x ($\mu m$)')
# plt.ylabel('y ($\mu m$)')
# plt.colorbar()
# plt.title("Metabolism")
# plt.show()
# =============================================================================

#%% - Real metabolism

#%%
# =============================================================================
# fine_x=np.linspace(0,L,100)
# fine_y=pos_s[np.argmin(t.q_Multi_metab),1]+np.zeros(100)
#
#
#
# REC_phi,_,_ = m.t.Reconstruct_Multi(1,0,fine_x, fine_y)
#
# plt.plot(REC_phi)
# plt.show()
#
# #%%
# ratio=14
# Rec_avg=np.zeros((0,cells*ratio*cells*ratio))
# met_avg=np.zeros((0,cells**2))
#
# =============================================================================
