#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Mon Feb 14 11:18:37 2022

@author: pdavid

SCRIPT FOR THE SINGLE SOURCE AND TO EVALUATE THE NON LINEAR MODEL on a centered position with
both Dirichlet and periodic BCs

"""
# djkflmjaze
import os

import matplotlib.pylab as pylab
import matplotlib.pyplot as plt
import numpy as np
import pandas as pd

directory_script = os.path.dirname(__file__)
csv_directory = os.path.join(directory_script, "csv_outputs")
with open(os.path.join(directory_script,'../../current_directory.txt'), 'r') as file:
    file_contents = file.read()
# Now, file_contents contains the entire content of the file as a string

source_directory=os.path.join(file_contents[:-1], 'src')
import sys
sys.path.append(source_directory)

from Reconstruction_functions import coarse_cell_center_rec
from Small_functions import plot_sketch
from Testing import Testing

directory_script = os.path.dirname(__file__)
csv_directory = os.path.join(directory_script, "csv_outputs")


params = {
    "legend.fontsize": "x-large",
    "figure.figsize": (10, 10),
    "axes.labelsize": "x-large",
    "axes.titlesize": "x-large",
    "xtick.labelsize": "x-large",
    "ytick.labelsize": "x-large",
    "font.size": 24,
    "lines.linewidth": 4,
    "lines.markersize": 15,
}
pylab.rcParams.update(params)


# 0-Set up the sources
# 1-Set up the domain
alpha = 50

Da_t = 5
D = 1
K0 = 1 / D
L = 240

cells = 8
h_coarse = L / cells


# Metabolism Parameters
M = Da_t * D / L**2
phi_0 = 0.1
conver_residual = 5e-5
stabilization = 0.5

# Definition of the Cartesian Grid
x_coarse = np.linspace(h_coarse / 2, L - h_coarse / 2, int(np.around(L / h_coarse)))
y_coarse = x_coarse

# V-chapeau definition
directness = 9
print("directness=", directness)


# pos_s=(1-np.array([[0.5,0.05+1/alpha/2]]))*L

pos_s1 = np.array(
    [
        [0.45, 0.02],
        [0.24, 0.17],
        [0.6, 0.23],
        [0.23, 0.27],
        [0.55, 0.33],
        [1.02, 0.41],
        [0.96, 0.43],
    ]
)
pos_s2 = np.array(
    [
        [0.27, 0.6],
        [0.53, 0.65],
        [0.59, 0.62],
        [0.67, 0.69],
        [0.13, 0.75],
        [0.15, 0.93],
        [0.2, 0.87],
        [0.28, 0.98],
        [0.8, 0.85],
        [0.83, 0.92],
    ]
)
pos_s3 = np.concatenate((pos_s1, pos_s2))

pos_s3[:, 0] -= 0.06
pos_s3[:, 1] -= 0.03

pos_s = (pos_s3 * 0.8 + 0.1) * L

# pos_s[8,0]=127
# pos_s[9,0]=140

S = len(pos_s)
Rv = L / alpha + np.zeros(S)
# ratio=int(40/cells)*2
ratio = int(100 * h_coarse // L / 2)

print("h coarse:", h_coarse)
K_eff = K0 / (np.pi * Rv**2)


p = np.linspace(0, 1, 100)
if np.min(p - M * (1 - phi_0 / (phi_0 + p))) < 0:
    print("There is an error in the metabolism")


# =============================================================================
# C_v_array = np.ones(S)
# C_v_array[[2, 5, 8, 11, 14]] = 0
# =============================================================================

#I changed the position of the sources so it looks prettier!!!!

C_v_array = np.ones(S) - 1
C_v_array[[2, 3, 9, 11, 15]] = 1

BC_value = np.array([0, 0, 0.3, 0.3])
BC_type = np.array(["Neumann", "Neumann", "Dirichlet", "Dirichlet"])

BC_value = np.array([0, 0.2, 0, 0])
BC_type = np.array(["Neumann", "Dirichlet", "Periodic", "Periodic"])
BC_type = np.array(["Periodic", "Periodic", "Periodic", "Periodic"])

# What comparisons are we making
COMSOL_reference = 1
non_linear = 1
directory_COMSOL = directory_script + "/COMSOL_output/linear"
directory_COMSOL_metab = directory_script + "/COMSOL_output/metab"

#%%

# =============================================================================
# range_cells=np.array([5,7,10,15,20,30])
# save_csv(csv_directory + '/range_cells.csv', ['range of cells'],range_cells)
#
# =============================================================================
range_cells = np.squeeze(np.array(pd.read_csv(csv_directory + "/range_cells.csv")))

if not os.path.exists(csv_directory):
    os.mkdir(csv_directory)
if not os.path.exists(csv_directory + "/linear"):
    os.mkdir(csv_directory + "/linear")
if not os.path.exists(csv_directory + "/metab"):
    os.mkdir(csv_directory + "/metab")

for i in range_cells:
    if not os.path.exists(csv_directory + "/linear/cells={}".format(i)):
        os.mkdir(csv_directory + "/linear/cells={}".format(i))
    if not os.path.exists(csv_directory + "/metab/cells={}".format(i)):
        os.mkdir(csv_directory + "/metab/cells={}".format(i))

#%%


err_q_linear = np.array([])
err_phi_linear = np.array([])
err_q_metab = np.array([])
err_phi_metab = np.array([])

FV_err_q_linear = np.array([])
FV_err_phi_linear = np.array([])

FV_q_linear = np.array([])

FV_err_q_metab = np.array([])
FV_err_phi_metab = np.array([])


cells = 8
h_coarse = L / cells
# Definition of the Cartesian Grid
x_coarse = np.linspace(h_coarse / 2, L - h_coarse / 2, int(np.around(L / h_coarse)))
y_coarse = x_coarse
ratio = int(100 * h_coarse // L / 4) * 4
ratio = 40
directness = np.array([1, 2, 3, 4, 6, 12])[np.where(range_cells == cells)[0][0]]
# directness=60
plot_sketch(x_coarse, y_coarse, directness, h_coarse, pos_s, L, directory_script)
t = Testing(
    pos_s, Rv, cells, L, K_eff, D, directness, ratio, C_v_array, BC_type, BC_value
)

s_Multi_cart_coarse_linear, q_Multi_linear = t.Multi()
phi_Multi_cart_fine_linear, _, _ = t.Reconstruct_Multi(0, 0)

s_Multi_cart_coarse_metab, q_Multi_metab = t.Multi(M, phi_0)
phi_Multi_cart_fine_metab, _, _ = t.Reconstruct_Multi(12, 0)

length = cells * ratio
x_c, y_c = np.zeros((cells * ratio) ** 2), np.zeros((cells * ratio) ** 2)

#%%
def PlotAndSave_Cartesian(data, file):
    # Generate a sample plot
    fig, ax = plt.subplots()
    im = ax.imshow(data, cmap="jet", origin="lower", interpolation="none")

    # Customize the colorbar
    cbar = fig.colorbar(
        im, fraction=0.05, aspect=15
    )  # Adjust the fraction to control the size

    ticks = np.linspace(np.min(data), np.max(data), 6)[1:-1]
    cbar.set_ticks(ticks)  # Set custom tick positions
    ticks = np.char.mod("%.2f", np.around(ticks, decimals=2)).tolist()
    cbar.set_ticklabels(
        ticks, fontsize=36
    )  # Set custom tick labels with increased fontsize

    # Add a label on top of the colorbar
    # cbar.ax.text(0.5, 0.2, 'Value', ha='center', va='center', fontsize=50)  # Adjust the position and fontsize as desired
    plt.savefig(file)
    plt.show()

def PlotAndSave(color_data, x_data, y_data, file, minn, maxx):
    # Generate a sample plot
    fig, ax = plt.subplots()
    im = ax.tricontourf(x_data, y_data, color_data, cmap="jet", levels=100, antialiased=False)

    # Customize the colorbar
    cbar = fig.colorbar(
        im, fraction=0.05, aspect=15
    )  # Adjust the fraction to control the size

    ticks = np.linspace(minn, maxx, 6)[1:-1]
    cbar.set_ticks(ticks)  # Set custom tick positions
    ticks = np.char.mod("%.2f", np.around(ticks, decimals=2)).tolist()
    cbar.set_ticklabels(
        ticks, fontsize=36
    )  # Set custom tick labels with increased fontsize

    # Add a label on top of the colorbar
    # cbar.ax.text(0.5, 0.2, 'Value', ha='center', va='center', fontsize=50)  # Adjust the position and fontsize as desired
    plt.savefig(file)
    plt.show()

#%%
file = "/home/pdavid/Bureau/PhD/Presentations/Article_October2022/Results_figs/Multiple_source/contour.svg"
PlotAndSave_Cartesian(phi_Multi_cart_fine_linear, file)

#%%
from Reconstruction_functions import coarse_cell_center_rec

file = "/home/pdavid/Bureau/PhD/Presentations/Article_October2022/Results_figs/Multiple_source/contour_coarse.pdf"

phi_coarse = coarse_cell_center_rec(
    t.Multi_linear_object.x,
    t.Multi_linear_object.y,
    s_Multi_cart_coarse_linear,
    t.pos_s,
    t.s_blocks,
    q_Multi_linear,
    directness,
    Rv,
    D,
)
PlotAndSave_Cartesian(phi_coarse, file)

#%%
from Testing import extract_COMSOL_data
directory_COMSOL_linear_pretty=directory_script + '/COMSOL_contour_example'
phi_FEM_linear, x_FEM_linear, y_FEM_linear = extract_COMSOL_data(
    directory_COMSOL_linear_pretty, [0, 1, 0]
)
# =============================================================================
# phi_Multi_FEM_linear, _, _ = t.Reconstruct_Multi(
#     0, 0, x_FEM_linear / 1e6, y_FEM_linear / 1e6
# )
# =============================================================================
file_COMSOL = "/home/pdavid/Bureau/PhD/Presentations/Article_October2022/Results_figs/Supp_figs/contour_multi_COMSOL.pdf"
PlotAndSave(phi_FEM_linear, x_FEM_linear/1e6, y_FEM_linear/1e6,file_COMSOL, np.min(phi_Multi_cart_fine_linear), np.max(phi_Multi_cart_fine_linear))
