#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Sun Jul 23 12:03:12 2023

@author: pdavid
"""

import os

import matplotlib.pylab as pylab
import matplotlib.pyplot as plt
import numpy as np

directory_script = os.path.dirname(__file__)
csv_directory = os.path.join(directory_script, "csv_outputs")
with open(os.path.join(directory_script,'../../current_directory.txt'), 'r') as file:
    file_contents = file.read()
# Now, file_contents contains the entire content of the file as a string

source_directory=os.path.join(file_contents[:-1], 'src')
import sys
sys.path.append(source_directory)


from Reconstruction_functions import coarse_cell_center_rec
from Small_functions import get_MRE, plot_sketch
from Testing import FEM_to_Cartesian, Testing, extract_COMSOL_data, save_csv
import sys

print(sys.argv)
directory_script = os.getcwd()
csv_directory = os.path.join(directory_script, "csv_V")


params = {
    "legend.fontsize": "x-large",
    "figure.figsize": (10, 10),
    "axes.labelsize": "x-large",
    "axes.titlesize": "x-large",
    "xtick.labelsize": "x-large",
    "ytick.labelsize": "x-large",
    "font.size": 24,
    "lines.linewidth": 4,
    "lines.markersize": 15,
}
pylab.rcParams.update(params)
err_q_linear=np.genfromtxt(csv_directory + "/err_q_linear.csv", delimiter=' ', skip_header=True, dtype=float, encoding='utf-8')
err_phi_linear=np.genfromtxt(csv_directory + "/err_phi_linear.csv", delimiter=' ', skip_header=True, dtype=float, encoding='utf-8')
err_q_metab=np.genfromtxt(csv_directory + "/err_q_metab.csv", delimiter=' ', skip_header=True, dtype=float, encoding='utf-8')
err_phi_metab=np.genfromtxt(csv_directory + "/err_phi_metab.csv", delimiter=' ', skip_header=True, dtype=float, encoding='utf-8')
n=np.genfromtxt(csv_directory + "/directness.csv", delimiter=' ', skip_header=True, dtype=float, encoding='utf-8').astype(int)


plt.plot(2 * n + 1, err_q_linear, "-s", color="b", label="err_q_linear")
plt.plot(2 * n + 1, err_q_metab, ":s", color="b", label="err_q_metab")
plt.plot(2 * n + 1, 0.1/ (n+1) ** 2, "--", color="k")
plt.yscale("log")
plt.ylim((1e-3, 0.2))
plt.xlabel("n")
plt.ylabel("$\\varepsilon_q^g$", rotation=0)
plt.savefig(
    directory_script + "/err_n.svg"
)
plt.show()