#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Mon Feb 14 11:18:37 2022

@author: pdavid






SCRIPT FOR THE SINGLE SOURCE AND TO EVALUATE THE NON LINEAR MODEL on a centered position with
both Dirichlet and periodic BCs

"""
# djkflmjaze
import os

# =============================================================================
# Malphigui = 0
#
# if Malphigui:
#     directory = "/home/pdavid/Bureau/Updated_BCs_2/Code"  # Malpighi
#     directory_script = (
#         "/home/pdavid/Bureau/Updated_BCs_2/Figures_and_Tests/Double_source"
#     )
#     csv_directory = (
#         "/home/pdavid/Bureau/Updated_BCs_2/Figures_and_Tests/Double_source/csv_outputs"
#     )
# else:  # Auto_58
#     directory = "/home/pdavid/Bureau/Code/Updated_BCs_2/Code/"
#     directory_script = (
#         "/home/pdavid/Bureau/Code/Updated_BCs_2/Figures_and_Tests/Double_source"
#     )
#     csv_directory = "/home/pdavid/Bureau/Code/Updated_BCs_2/Figures_and_Tests/Double_source/csv_outputs"
# =============================================================================

directory_script = os.path.dirname(__file__)
csv_directory = os.path.join(directory_script, "csv_outputs")

directory_script = os.path.dirname(__file__)
csv_directory = os.path.join(directory_script, "csv_outputs")
with open(os.path.join(directory_script,'../../current_directory.txt'), 'r') as file:
    file_contents = file.read()
# Now, file_contents contains the entire content of the file as a string

source_directory=os.path.join(file_contents[:-1], 'src')
import sys
sys.path.append(source_directory)

import matplotlib.pylab as pylab
import matplotlib.pyplot as plt
import numpy as np
import pandas as pd

from Small_functions import get_MRE, plot_sketch
from Testing import Testing, extract_COMSOL_data, save_csv

params = {
    "legend.fontsize": "x-large",
    "figure.figsize": (8, 8),
    "axes.labelsize": "x-large",
    "axes.titlesize": "x-large",
    "xtick.labelsize": "x-large",
    "ytick.labelsize": "x-large",
}
pylab.rcParams.update(params)


# 0-Set up the sources
# 1-Set up the domain
alpha = 50

Da_t = 10
D = 1
K0 = 1
L = 240

cells = 5
h_coarse = L / cells

# Definition of the Cartesian Grid
x_coarse = np.linspace(h_coarse / 2, L - h_coarse / 2, int(np.around(L / h_coarse)))
y_coarse = x_coarse

# V-chapeau definition
directness = 1
print("directness=", directness)

S = 2
Rv = L / alpha + np.zeros(S)
R_size = L / alpha
pos_s = np.array([[0.5, 0.5]]) * L

# ratio=int(40/cells)*2
ratio = int(100 * h_coarse // L)

print("h coarse:", h_coarse)
K_eff = K0 / (np.pi * Rv**2)


C_v_array = np.array([1,0])

BC_value = np.array([0, 0.2, 0, 0.2])
BC_type = np.array(["Periodic", "Periodic", "Neumann", "Dirichlet"])

save_csv(
    csv_directory + "/parameters.csv", ["Parameters"], np.array([L, cells, alpha, K0])
)


# What comparisons are we making
COMSOL_reference = 1
non_linear = 1
Peaceman_reference = 1
coarse_reference = 1

#%%

def PlotAndSave(color_data, x_data, y_data, file, minn, maxx):
    # Generate a sample plot
    fig, ax = plt.subplots()
    im = ax.tricontourf(x_data, y_data, color_data, cmap="jet", levels=200)

    # Customize the colorbar
    cbar = fig.colorbar(
        im, fraction=0.05, aspect=15
    )  # Adjust the fraction to control the size

    ticks = np.linspace(minn, maxx, 6)[1:-1]
    cbar.set_ticks(ticks)  # Set custom tick positions
    ticks = np.char.mod("%.2f", np.around(ticks, decimals=2)).tolist()
    cbar.set_ticklabels(
        ticks, fontsize=36
    )  # Set custom tick labels with increased fontsize

    # Add a label on top of the colorbar
    # cbar.ax.text(0.5, 0.2, 'Value', ha='center', va='center', fontsize=50)  # Adjust the position and fontsize as desired
    plt.savefig(file)
    plt.show()



#%% - Source-sink big neigh
from Testing import extract_COMSOL_data

directness = 2

d=12*Rv[0]
directory_COMSOL_contour = directory_script + "/COMSOL_output_example"
phi_FEM_linear, x_FEM_linear, y_FEM_linear = extract_COMSOL_data(directory_COMSOL_contour, [0,1,0])
pos_s = (
    np.array([[0, -d / 2 - Rv[0]], [0, d / 2 + Rv[1]]])
    + np.array([[0.5, 0.5], [0.5, 0.5]]) * L
)
print(
    "distance between sources= ",
    (np.linalg.norm(pos_s[1] - pos_s[0]) - np.sum(Rv)) / R_size,
)
plot_sketch(x_coarse, y_coarse, directness, h_coarse, pos_s, L, directory_script)

ratio=50
t = Testing(
    pos_s, Rv, cells, L, K_eff, D, directness, ratio, C_v_array, BC_type, BC_value
)

s_Multi_cart_coarse_linear, q_Multi_linear = t.Multi()
phi_Multi_cart_fine_linear, _, _ = t.Reconstruct_Multi(0, 0)

plt.imshow(phi_Multi_cart_fine_linear, origin='lower', cmap='jet')

file_COMSOL = "/home/pdavid/Bureau/PhD/Presentations/Article_October2022/Results_figs/Supp_figs/contour_double_COMSOL.pdf"
PlotAndSave(phi_FEM_linear, x_FEM_linear/1e6, y_FEM_linear/1e6,file_COMSOL, np.min(phi_Multi_cart_fine_linear), np.max(phi_Multi_cart_fine_linear))







