#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Mon Feb 14 11:18:37 2022

@author: pdavid

SCRIPT FOR THE SINGLE SOURCE AND TO EVALUATE THE NON LINEAR MODEL on a centered position with
both Dirichlet and periodic BCs

"""
# djkflmjaze
import os

directory_script = os.path.dirname(__file__)
csv_directory = os.path.join(directory_script, "csv_outputs")

directory_script = os.path.dirname(__file__)
csv_directory = os.path.join(directory_script, "csv_outputs")
with open(os.path.join(directory_script,'../../current_directory.txt'), 'r') as file:
    file_contents = file.read()
# Now, file_contents contains the entire content of the file as a string

source_directory=os.path.join(file_contents[:-1], 'src')
import sys
sys.path.append(source_directory)

import matplotlib.pylab as pylab
import matplotlib.pyplot as plt
import numpy as np
import pandas as pd

from Reconstruction_functions import coarse_cell_center_rec
from Small_functions import get_MRE, plot_sketch
from Testing import (
    FEM_to_Cartesian,
    Testing,
    extract_COMSOL_data,
    save_csv,
    save_var_name_csv,
)

params = {
    "legend.fontsize": "x-large",
    "figure.figsize": (8, 8),
    "axes.labelsize": "x-large",
    "axes.titlesize": "x-large",
    "xtick.labelsize": "x-large",
    "ytick.labelsize": "x-large",
}
pylab.rcParams.update(params)


# 1-Set up the domain
alpha = 50 #Aspect ratio of the source \alpha=L/Rv

Da_t = 10
D = 1
K0 = 10
L = 240

cells =21
h_coarse = L / cells


# Metabolism Parameters
M = Da_t * D / L**2
phi_0 = 0.05
conver_residual = 5e-5
stabilization = 0.5

# Definition of the Cartesian Grid
x_coarse = np.linspace(h_coarse / 2, L - h_coarse / 2, int(np.around(L / h_coarse)))
y_coarse = x_coarse

# \widehat{V} definition
directness = 4
print("directness=", directness)

S = 1 #Total amount of sources in the simulation
Rv = L / alpha + np.zeros(S) #array containing the radii of the vessels
pos_s = np.array([[0.5, 0.5]]) * L #position of the sources

ratio = int(100 * h_coarse // L / 4) * 2 #ratio used for the reconstruction (post processing, it does not affect)

print("h coarse:", h_coarse)
#The K_eff in the article corresponds to K0 here. K_eff (here, in the code) is non-dimensionalized by the cross section surface of the vessel
K_eff = K0 / (np.pi * Rv**2)

#The following tests if the combination of parameters for the metabolism is the appropriate one
p = np.linspace(0, 1, 100)
if np.min(p - M * (1 - phi_0 / (phi_0 + p))) < 0:
    print("There is an error in the metabolism")


#Set the intravascular concentration
C_v_array = np.ones(S)

#Boundary conditions
BC_value = np.array([0, 0.2, 0, 0.2])
BC_type = np.array(["Periodic", "Periodic", "Neumann", "Dirichlet"])

# =============================================================================
# BC_value = np.array([0, 0,0,0])+0.8
# BC_type = np.array(["Dirichlet", "Dirichlet", "Dirichlet", "Dirichlet"])
# =============================================================================

# What comparisons are we making
non_linear = 1       #We also use the COMSOL comparison for the reactive problem that is stored in directory_COMSOL_metab


plot_sketch(x_coarse, y_coarse, directness, h_coarse, pos_s, L, directory_script)


#%% - Testing is the class with the main computation and post processing functions
#We create the simulation object t
t = Testing(
    pos_s, Rv, cells, L, K_eff, D, directness, ratio, C_v_array, BC_type, BC_value
)

s_Multi_cart_linear, q_Multi_linear = t.Multi()

#Reconstruction of the linear model at the nodes of the FEM from COMSOL for comparison
Multi_rec_linear, _, _ = t.Reconstruct_Multi(0, 1)

#%%
c = 0
plt.plot(t.x_fine, t.array_phi_field_x_Multi[c], label="Multi")
plt.xlabel("x")
plt.legend()
plt.title("linear")
plt.show()

plt.plot(t.y_fine, t.array_phi_field_y_Multi[c], label="Multi")
plt.xlabel("y")
plt.legend()
plt.title("linear")
plt.show()
#%%


Multi_FV_metab, q_Multi_metab = t.Multi(M, phi_0)
Multi_rec_metab, _, _ = t.Reconstruct_Multi(1, 1)

plt.plot(t.x_fine, t.array_phi_field_x_Multi[c], label="Multi")
plt.xlabel("x")
plt.title("Metabolism")
plt.legend()
plt.show()

plt.plot(t.y_fine, t.array_phi_field_y_Multi[c], label="Multi")
plt.xlabel("y")
plt.legend()
plt.title("Metabolism")
plt.show()
orig_tuple_x=t.x_fine, t.array_phi_field_x_Multi[c]
orig_tuple_y=t.y_fine, t.array_phi_field_y_Multi[c]


#%% - Non-linear constant consumption
import scipy as sp
import pdb
Linear_operator=t.n.LIN_MAT
H0=t.n.H0
sol = sp.sparse.linalg.spsolve(Linear_operator, -H0+np.append(M*t.n.h**2*np.ones(cells**2), 0))

t.Multi_metab_object.s_FV_metab=sol[:-1]
t.Multi_metab_object.q_metab=np.array([sol[-1]])
#Reconstruction of the linear model at the nodes of the FEM from COMSOL for comparison
t.Reconstruct_Multi(1, 1)
plt.plot(t.x_fine, t.array_phi_field_x_Multi[c], label="Multi")
plt.plot(orig_tuple_x[0], orig_tuple_x[1], label="orig")
plt.xlabel("x")
plt.title("Metabolism")
plt.legend()
plt.show()

plt.plot(t.y_fine, t.array_phi_field_y_Multi[c], label="Multi")
plt.plot(orig_tuple_y[0], orig_tuple_y[1], label="orig")
plt.xlabel("y")
plt.legend()
plt.title("Metabolism")
plt.show()


#%%

cons, _=t.get_reaction_map(s_Multi_cart_linear, q_Multi_linear)
plt.imshow(cons)
plt.colorbar()
#%%
CMRO, cons_q=t.get_reaction_map(Multi_FV_metab, q_Multi_metab)
plt.imshow(CMRO)
plt.colorbar()


#%%

phi_new=sp.sparse.linalg.spsolve(t.n.LIN_MAT, -t.n.H0+np.concatenate((np.ndarray.flatten(CMRO), cons_q))*t.n.h**2)


#%% - So the pipeline: Solve the transport of oxygen with michaelis menten metabolism term 


#Set the intravascular concentration
C_v_array = np.ones(S)

#Boundary conditions
BC_value = np.array([0, 0.2, 0, 0.2])
BC_type = np.array(["Periodic", "Periodic", "Periodic", "Periodic"])

# What comparisons are we making
non_linear = 1       #We also use the COMSOL comparison for the reactive problem that is stored in directory_COMSOL_metab

plot_sketch(x_coarse, y_coarse, directness, h_coarse, pos_s, L, directory_script)

t = Testing(
    pos_s, Rv, cells, L, K_eff, D, directness, ratio, C_v_array, BC_type, BC_value
)


Multi_FV_metab, q_Multi_metab = t.Multi(M, phi_0)
Multi_rec_metab, _, _ = t.Reconstruct_Multi(1, 1)

plt.plot(t.x_fine, t.array_phi_field_x_Multi[c], label="Multi")
plt.xlabel("x")
plt.title("Metabolism")
plt.legend()
plt.show()

plt.plot(t.y_fine, t.array_phi_field_y_Multi[c], label="Multi")
plt.xlabel("y")
plt.legend()
plt.title("Metabolism")
plt.show()
orig_tuple_x=t.x_fine, t.array_phi_field_x_Multi[c]
orig_tuple_y=t.y_fine, t.array_phi_field_y_Multi[c]













