%% Find Bykov-T point at APE branch and continuate it
%
% This is a demo version showing how to continue a Bykov T-point
%
%% Initialize
close all
clear all
restoredefaultpath

addpath(genpath('../code/APE_funcs'))
addpath(genpath('../code/Bykov_funcs'))
addpath(genpath('../code/Additional_functions'))
APE_init;

var='inj' % continuation variable (must be element of ip)
varip=ip.inj % index of continuation variable

load('Example_APE_br_inj.mat')

%% ---------------------- Computation of Bykov point ------------------------------
% as two combined connecting orbits/ heteroclinic connections between
% square wave - Plateaus and CW-state:
% - (Plateaus and CW have two complex conjugated pairs of unstable eigenvalues)
% - here: both connections have codimension 1
% - Bykov-point: codimension 2 bifurcation -> create bykov point as the
% combined problem of two heteroclinic connections from pleateau to CW and
% CW to plateau



%% pick initial data near Bykov T-point
point_ind=200;
mixed_type = APE_br.point(point_ind)

figure(1); clf; hold on;
plot( mixed_type.mesh, mixed_type.profile(1,:), '-','Color','b');
plot( mixed_type.mesh, mixed_type.profile(2,:), '-','Color','r');
plot( mixed_type.mesh, mixed_type.profile(3,:), '-','Color','c');
plot( mixed_type.mesh, mixed_type.profile(4,:), '-','Color','m');
plot( mixed_type.mesh, mixed_type.profile(5,:), '-','Color','b');
plot( mixed_type.mesh, mixed_type.profile(6,:), '-','Color','r');
plot( mixed_type.mesh, mixed_type.profile(7,:), '-','Color','c');
plot( mixed_type.mesh, mixed_type.profile(8,:), '-','Color','m');


%% pick equilibria: saddles for heteroclinic connection (=Bykov-point)

ind_p1=find(mixed_type.mesh<0.25,1,'last');
ind_p2=find(mixed_type.mesh<0.48,1,'last');
ind_p3=find(mixed_type.mesh<0.6,1,'last');

P1 = mixed_type.profile(:,ind_p1);
P2 = mixed_type.profile(:,ind_p2);
P3 = mixed_type.profile(:,ind_p3);

%% cut out initial guess for heteroclinic connection from P1 to P2

ind_s=find(mixed_type.mesh<0.393,1,'last');
ind_e=find(mixed_type.mesh<0.441,1,'last');
while mod(ind_s-ind_e,mixed_type.degree)~=0
    ind_e=round(ind_e+1);
end

init_left=mixed_type;
init_left.mesh=(mixed_type.mesh(ind_s:ind_e)-mixed_type.mesh(ind_s));
init_left.mesh=init_left.mesh./init_left.mesh(end);
init_left.profile=mixed_type.profile(:,ind_s:ind_e);
init_left.period=(mixed_type.mesh(ind_e)-mixed_type.mesh(ind_s))*mixed_type.period;
init_left.parameter(ip.T)=(mixed_type.mesh(ind_e)-mixed_type.mesh(ind_s))*mixed_type.period;

%% convert into connecting orbit from P1 to P2
h_mthd = df_mthod('comp_hcli');
h_mthd.point.print_residual_info=1;

% create connecting orbit
init_left= dde_comp_hcli_create('mesh',init_left.mesh,'profile',init_left.profile,'degree',init_left.degree,...
    'parameter',init_left.parameter, 'period',init_left.period, 'x1',P1,'x2',P2) 
% computes remaining variables
init_left=p_to_comp_hcli(init_left,'kind','comp_hcli','funcs',funcs)


[hom_left,suc]=p_correc(funcs,init_left,ip.tau,[],h_mthd.point)

% remeshing to obtain accurate solution
hom_left= p_remesh(hom_left , 8 ,20)
[hom_left,suc]=p_correc(funcs,hom_left,ip.tau,[],h_mthd.point)
%% Compare Cutout and corrected profile

figure(2);clf;hold on;
plot(init_left.mesh,init_left.profile(1,:),'-','Color','b','LineWidth',2)
plot(init_left.mesh,init_left.profile(2,:),'-','Color','b','LineWidth',2)
plot(init_left.mesh,init_left.profile(3,:),'-','Color','b','LineWidth',2)
plot(init_left.mesh,init_left.profile(4,:),'-','Color','b','LineWidth',2)
plot(init_left.mesh,init_left.profile(5,:),'-','Color','b','LineWidth',2)
plot(init_left.mesh,init_left.profile(6,:),'-','Color','b','LineWidth',2)
plot(init_left.mesh,init_left.profile(7,:),'-','Color','b','LineWidth',2)
plot(init_left.mesh,init_left.profile(8,:),'-','Color','b','LineWidth',2)
plot(hom_left.mesh,hom_left.profile(1,:),'--','Color','r','LineWidth',2)
plot(hom_left.mesh,hom_left.profile(2,:),'--','Color','r','LineWidth',2)
plot(hom_left.mesh,hom_left.profile(3,:),'--','Color','r','LineWidth',2)
plot(hom_left.mesh,hom_left.profile(4,:),'--','Color','r','LineWidth',2)
plot(hom_left.mesh,hom_left.profile(5,:),'--','Color','r','LineWidth',2)
plot(hom_left.mesh,hom_left.profile(6,:),'--','Color','r','LineWidth',2)
plot(hom_left.mesh,hom_left.profile(7,:),'--','Color','r','LineWidth',2)
plot(hom_left.mesh,hom_left.profile(8,:),'--','Color','r','LineWidth',2)




%% cut out initial guess for heteroclinic connection from P2 to P3

ind_s=find(mixed_type.mesh<0.517,1,'last');
ind_e=find(mixed_type.mesh<0.57,1,'last');
while mod(ind_s-ind_e,mixed_type.degree)~=0
    ind_e=round(ind_e+1);
end
init_right=mixed_type;
init_right.mesh=(mixed_type.mesh(ind_s:ind_e)-mixed_type.mesh(ind_s));
init_right.mesh=init_right.mesh./init_right.mesh(end);
init_right.profile=mixed_type.profile(:,ind_s:ind_e);
init_right.period=(mixed_type.mesh(ind_e)-mixed_type.mesh(ind_s))*mixed_type.period;
init_right.parameter(ip.T)=(mixed_type.mesh(ind_e)-mixed_type.mesh(ind_s))*mixed_type.period;


%% convert into connecting orbit from P2 to P3

% create connecting orbit
init_right= dde_comp_hcli_create('mesh',init_right.mesh,'profile',init_right.profile,'degree',init_right.degree,...
    'parameter',init_right.parameter, 'period',init_right.period, 'x1',P2,'x2',P3) 
% computes remaining variables
init_right=p_to_comp_hcli(init_right,'kind','comp_hcli','funcs',funcs)

[hom_right,suc]=p_correc(funcs,init_right,ip.tau,[],h_mthd.point)

% remeshing to obtain accurate solution
hom_right= p_remesh(hom_right , 8 ,20)
[hom_right,suc]=p_correc(funcs,hom_right,ip.tau,[],h_mthd.point)
%% Compare Cutout and corrected profile

figure(3);clf;hold on;
plot(init_right.mesh,init_right.profile(1,:),'-','Color','b','LineWidth',2)
plot(init_right.mesh,init_right.profile(2,:),'-','Color','b','LineWidth',2)
plot(init_right.mesh,init_right.profile(3,:),'-','Color','b','LineWidth',2)
plot(init_right.mesh,init_right.profile(4,:),'-','Color','b','LineWidth',2)
plot(init_right.mesh,init_right.profile(5,:),'-','Color','b','LineWidth',2)
plot(init_right.mesh,init_right.profile(6,:),'-','Color','b','LineWidth',2)
plot(init_right.mesh,init_right.profile(7,:),'-','Color','b','LineWidth',2)
plot(init_right.mesh,init_right.profile(8,:),'-','Color','b','LineWidth',2)
plot(hom_right.mesh,hom_right.profile(1,:),'--','Color','r','LineWidth',2)
plot(hom_right.mesh,hom_right.profile(2,:),'--','Color','r','LineWidth',2)
plot(hom_right.mesh,hom_right.profile(3,:),'--','Color','r','LineWidth',2)
plot(hom_right.mesh,hom_right.profile(4,:),'--','Color','r','LineWidth',2)
plot(hom_right.mesh,hom_right.profile(5,:),'--','Color','r','LineWidth',2)
plot(hom_right.mesh,hom_right.profile(6,:),'--','Color','r','LineWidth',2)
plot(hom_right.mesh,hom_right.profile(7,:),'--','Color','r','LineWidth',2)
plot(hom_right.mesh,hom_right.profile(8,:),'--','Color','r','LineWidth',2)


%% convert homoclinics from P1 to P2 and P2 to P3 into one data structure to compute Bykov-point

bykov_init=p_to_bykov(hom_left,hom_right)

[bykov,suc]=p_correc(funcs,bykov_init,[varip,ip.tau],[],h_mthd.point)

%% continue branch of heteroclinic for bif diagram in E_l and V_4

APE_br_bykov=df_brnch(funcs, [varip,ip.delta,ip.tau], 'bykov')

APE_br_bykov.method.point.extra_condition=0;
APE_br_bykov.method.point.remesh=1;

APE_br_bykov.parameter.min_bound=[varip 0, ip.delta, 0, ip.tau 0];
APE_br_bykov.parameter.max_bound=[varip 0.9; ip.delta 0.7];
APE_br_bykov.parameter.max_step=[varip 5e-3; ip.delta 0.2];


APE_br_bykov.point=bykov;
bykov_a=bykov;
bykov_a.parameter(ip.delta)=bykov_a.parameter(ip.delta) - 0.0001;
[bykov_a,suc] = p_correc(funcs,bykov_a,[varip,ip.tau],[],APE_br_bykov.method.point)
APE_br_bykov.point(2)=bykov_a;


figure(4);clf;ax=gca;hold on;
[APE_br_bykov,s,f,r]=br_contn_bykov(funcs,APE_br_bykov,20,'plotaxis',ax)
APE_br_bykov=br_rvers(APE_br_bykov);
%%
[APE_br_bykov,s,f,r]=br_contn_bykov(funcs,APE_br_bykov,20,'plotaxis',ax)
xlabel('Y_0');ylabel('detuning \delta');
caption=sprintf('branch of bykov points');
title(caption);

%%
save('APE_br_bykov.mat','APE_br_bykov')