%% Relative homoclinic solution from APE continuation demo
%
% This is a demo version showing how to get a homoclinic solution branch from the APE solution
%
%% Initialize
close all
clear all
restoredefaultpath

addpath(genpath('../code/APE_funcs'))
addpath(genpath('../code/Bykov_funcs'))
addpath(genpath('../code/Additional_functions'))
APE_init;

var='inj' % continuation variable (must be element of ip)
varip=ip.inj % index of continuation variable

load('Example_APE_br_inj.mat')

%% -------------------- Computation of square wave as connecting orbit in EPE -------------------------
% as connecting orbit square wave has pairs of complex conjugated unstable eigendirections:
% use adapted connecting orbit routine for 'comp_hcli'

% pick inital square wave
ind_point= find(arrayfun(@(x) x.parameter(varip) <= 0.7,APE_br.point),1,'first');
sw = APE_br.point(ind_point)

%% remesh stepwise:

sw= p_remesh(sw , 8 ,75)
[sw,suc]=p_correc(funcs,sw,[ip.tau],[],APE_br.method.point)
sw= p_remesh(sw , 8 ,101)
[sw,suc]=p_correc(funcs,sw,[ip.tau],[],APE_br.method.point)

% Plot cutout
figure(1); clf; hold on;
plot( sw.mesh, sw.profile(1,:), '-','Color','b');
plot( sw.mesh, sw.profile(2,:), '-','Color','r');
plot( sw.mesh, sw.profile(3,:), '-','Color','c');
plot( sw.mesh, sw.profile(4,:), '-','Color','m');

%% Take equilibria P1 and P2 from profile

ind_p1=find(sw.mesh<0.25,1,'last');
ind_p2=find(sw.mesh<0.7,1,'last');

P1 = sw.profile(:,ind_p1);
P2 = sw.profile(:,ind_p2);

%% cut out part of square wave for initial guess of connecting orbit
% the transition between P1 and P2 needs to be in the cutout
ind_s=find(sw.mesh<0.43,1,'last');
ind_e=find(sw.mesh<0.54,1,'last');
while mod(ind_s-ind_e,sw.degree)~=0
    ind_e=round(ind_e+1); 
end

hom_init=sw;
hom_init.mesh=(sw.mesh(ind_s:ind_e)-sw.mesh(ind_s));
hom_init.mesh=hom_init.mesh./hom_init.mesh(end);
hom_init.profile=sw.profile(:,ind_s:ind_e);
hom_init.period=(sw.mesh(ind_e)-sw.mesh(ind_s))*sw.period;
hom_init.parameter(ip.T)=(sw.mesh(ind_e)-sw.mesh(ind_s))*sw.period;


%% convert initial guess to connecting orbit with complex eigenpairs

h_mthd = df_mthod('comp_hcli');
h_mthd.point.print_residual_info=1;

% create relative homoclinic for complex conjugated eigenpairs
hom_init= dde_comp_hcli_create('mesh',hom_init.mesh,'profile',hom_init.profile,'degree',hom_init.degree,...
    'parameter',hom_init.parameter, 'period',hom_init.period, 'x1',P1,'x2',P2) 

hom_init=p_to_comp_hcli(hom_init,'kind','comp_hcli','funcs',funcs)

[hom,suc]=p_correc(funcs,hom_init,ip.tau,[],h_mthd.point)


%% Compare Cutout and corrected profile
figure(2);clf;hold on;
plot(hom_init.mesh,hom_init.profile(1,:),'-','Color','b','LineWidth',2)
plot(hom_init.mesh,hom_init.profile(2,:),'-','Color','b','LineWidth',2)
plot(hom_init.mesh,hom_init.profile(3,:),'-','Color','b','LineWidth',2)
plot(hom_init.mesh,hom_init.profile(4,:),'-','Color','b','LineWidth',2)
plot(hom_init.mesh,hom_init.profile(5,:),'-','Color','b','LineWidth',2)
plot(hom_init.mesh,hom_init.profile(6,:),'-','Color','b','LineWidth',2)
plot(hom_init.mesh,hom_init.profile(7,:),'-','Color','b','LineWidth',2)
plot(hom_init.mesh,hom_init.profile(8,:),'-','Color','b','LineWidth',2)
plot(hom.mesh,hom.profile(1,:),'--','Color','r','LineWidth',2)
plot(hom.mesh,hom.profile(2,:),'--','Color','r','LineWidth',2)
plot(hom.mesh,hom.profile(3,:),'--','Color','r','LineWidth',2)
plot(hom.mesh,hom.profile(4,:),'--','Color','r','LineWidth',2)
plot(hom.mesh,hom.profile(5,:),'--','Color','r','LineWidth',2)
plot(hom.mesh,hom.profile(6,:),'--','Color','r','LineWidth',2)
plot(hom.mesh,hom.profile(7,:),'--','Color','r','LineWidth',2)
plot(hom.mesh,hom.profile(8,:),'--','Color','r','LineWidth',2)


%% branch of square waves as connecting orbits
APE_br_hcl=df_brnch(funcs, [varip,ip.tau,ip.T], 'comp_hcli')

APE_br_hcl.method.point.extra_condition=1;  % to control growth of T in max_step
APE_br_hcl.method.point.remesh=0; % preserves initial meshing: here adapted

APE_br_hcl.parameter.max_bound=[varip 0.95];
APE_br_hcl.parameter.max_step=[varip 5e-3;ip.T 1];

% initial points
hom.parameter(ip.T)=hom.period; % for continuation in T
APE_br_hcl.point=hom;
hom_a=hom;
hom_a.parameter(varip)=hom_a.parameter(varip) - 0.0001;
[hom_a,suc] = p_correc(funcs,hom_a,[ip.tau,ip.T],[],APE_br_hcl.method.point)
APE_br_hcl.point(2)=hom_a;


figure(3);clf;ax=gca;hold on;
[APE_br_hcl,s,f,r]=br_contn(funcs,APE_br_hcl,25,'plotaxis',ax)
APE_br_hcl=br_rvers(APE_br_hcl);
APE_br_hcl.point(end-5:end)=[];
[APE_br_hcl,s,f,r]=br_contn(funcs,APE_br_hcl,10,'plotaxis',ax)
xlabel('Y_0');ylabel('detuning \delta');

%%
save('APE_br_hclin.mat','APE_br_hcl')
