%% APE from KGTI continuation demo
%
% This is a demo version of APE continuation from a KGTI branch
%
%% Initialize KGTI
close all
clear all
restoredefaultpath

addpath(genpath('../code/KGTI_funcs'))
addpath(genpath('../code/APE_funcs'))
addpath(genpath('../code/Additional_functions'))
KGTI_init;

load('KGTI_br_inj.mat')
branch=br_inj;


%% Pick a point from KGTI branch of Square Wave solutions
ind_point= find(arrayfun(@(x) x.parameter(ip.inj) <= 0.7,branch.point),1,'first'); 
point = branch.point(ind_point)

%% Remesh
point=p_remesh(point,3,linspace(0,1,601))
[point,suc]=p_correc(funcs,point,[],[],branch.method.point)


%% Initialize APE
% Note: KGTI_init and APE_init initialize the system, by setting funcs for
% the current system and creating ip as a vector containing parameter indices. By initializing the APE, funcs and ip is overwritten to
% always only have one system loaded.

APE_init;
var='inj' % continuation parameter (must be element of ip)
varip=ip.inj % index of continuation variable


%% Create APE profile from KGTI profile
extd_sol=point;

% Find APE tau as rho from KGTI:
extd_sol.parameter(ip.tau)=0.5*point.period-point.parameter(ip.tau);
extd_sol.parameter(ip.T)=point.period;

% T/2 shifted components from APE: 
ind_T2=find(point.mesh<=0.5,1,'last');
second_input=extd_sol;
second_input.profile=[second_input.profile(:,ind_T2:end), second_input.profile(:,2:ind_T2)];

extd_sol.profile=[extd_sol.profile; second_input.profile]

%% Plot eight components
figure(1); clf; hold on;
plot( extd_sol.mesh, extd_sol.profile(1,:), '-','Color','b');
plot( extd_sol.mesh, extd_sol.profile(2,:), '-','Color','r');
plot( extd_sol.mesh, extd_sol.profile(3,:), '-','Color','c');
plot( extd_sol.mesh, extd_sol.profile(4,:), '-','Color','m');
plot( extd_sol.mesh, extd_sol.profile(5,:), '--');
plot( extd_sol.mesh, extd_sol.profile(6,:), '--');
plot( extd_sol.mesh, extd_sol.profile(7,:), '--');
plot( extd_sol.mesh, extd_sol.profile(8,:), '--');

branch.method.point.extra_condition=1;
[extd_sol,suc]=p_correc(funcs,extd_sol,[ip.tau],[],branch.method.point)

%% Initialize APE branch
APE_br=df_brnch(funcs,[varip, ip.tau],'psol');
APE_br.method.point.extra_condition = 1;
APE_br.method.point.remesh = 0;
APE_br.parameter.max_bound=[varip 0.955];
APE_br.parameter.max_step=[varip 5e-3];

        xp_psol = df_measr([],varip,'psol');
        yp_psol.field = '';
        yp_psol.subfield = '';
        yp_psol.row = 'all';
        yp_psol.col='all' ; 
        yp_psol.func='integrate_profile';
APE_br.method.continuation.plot_measure.x = xp_psol;
APE_br.method.continuation.plot_measure.y = yp_psol;


APE_br.point=extd_sol;
extd_sol_a=extd_sol;
extd_sol_a.parameter(varip)= extd_sol_a.parameter(varip)+0.01;
[extd_sol_a,suc]=p_correc(funcs,extd_sol_a,[ip.tau],[],APE_br.method.point)
APE_br.point(2)=extd_sol_a;

%% Continuate APE branch
figure(2); clf; hold on;
APE_br=br_contn(funcs,APE_br,30);
APE_br=br_rvers(APE_br);
APE_br.point(end-3:end)=[];

APE_br=br_contn(funcs,APE_br,80);

save('APE_br_inj.mat','APE_br')

%%
br_plot(APE_br,APE_br.method.continuation.plot_measure.x,APE_br.method.continuation.plot_measure.y)













