function stability=dde_stst_eig(funcs,p,method,varargin)
%% compute stability information for stst 
% INPUT:
%   funcs problem functions
%	point solution point
%	method method parameters 
% OUTPUT:
%	stability stability information
% Update on 05/03/2007 ("flag_newhheur"  <=> (imag(method.lms_parameter_rho)~=0) )   
%
% $Id: dde_stst_eig.m 369 2019-08-27 00:07:02Z jansieber $
%
%%
default={'fill',[]};
[options,pass_on]=dde_set_options(default,varargin,'pass_on');
if ~isfield(method,'discretization')
    method.discretization='cheb';
end
[A,tau]=dde_stst_linearize_rhs(funcs,p);
stability=feval(['dde_stst_eig_',method.discretization],A,tau,'method',method,...
    'lhs_matrix',funcs.lhs_matrix(size(A,1)),pass_on{:});
if ~isempty(options.fill)
    ext=@(s)cat(1,s(:),repmat(options.fill,method.max_number_of_eigenvalues-length(s),1));
    stability.l0=ext(stability.l0).';
    stability.l1=ext(stability.l1);
end
end
