cur_path=pwd;
try
      cd('../code/KGTI_funcs') %% Insert path of KGTI_init;
catch
    warning('Adjust path in KGTI_init.m to the folder where the filed KGTI_init.m can be found');
end

%% Load DDE-Biftool and extension into Path
addpath('../dde_biftool/ddebiftool');
addpath('../dde_biftool/ddebiftool_extra_psol/');
addpath('../dde_biftool/ddebiftool_utilities/');
addpath('../dde_biftool/ddebiftool_extra_rotsym/');

cd(cur_path);
%% Set number of delays and create parameter names as strings
parnames={'delta','h','eta','phi','inj','tau','s','sigma','dt'};
cs=[parnames;num2cell(1:length(parnames))];
ip=struct(cs{:});


%% use symbolic functions to initialize KGTI system
sfuncs=set_symfuncs(@sym_KGTI,'sys_tau',@()ip.tau,'p_vectorized',false);
funcs=set_funcs('sys_rhs',sfuncs.sys_rhs,'sys_dirderi',sfuncs.sys_dirderi,...
    'sys_tau',@()ip.tau,'x_vectorized',true,'lhs_matrix',diag([1,1,0,0]));

