function bykov=p_to_bykov(point1,point2,varargin)
%% convert two connecting orbits to Bykov T-point
% INPUT:
%     point1, point2 a hcli structure,
%           where a good starting guess for the profile and steady
%           states are available
%     named (but mandatory) 'funcs': problem functions
% OUTPUT:
%     bykov a starting value to compute the exact Bykov T-point
%
% (c) DDE-BIFTOOL v. 2.02, 16/6/2002
%
% adapted from
% $Id: p_tohcli.m 308 2018-10-28 15:08:12Z jansieber $
% by M. Stöhr 2023/03/02
%%

if mod(length(point1.mesh),point1.degree)~=1
    err=[length(point1.mesh) point1.degree];
    error('P_TOHCLI: psol does not contain L=%d intervals of m=% points!',...
        err(1),err(2));
end


if mod(length(point2.mesh),point2.degree)~=1
    err=[length(point2.mesh) point2.degree];
    error('P_TOHCLI: psol does not contain L=%d intervals of m=% points!',...
        err(1),err(2));
end

if point1.degree ~= point2.degree
    error('This routine is only implemented for homoclinics with collocations of the same degree.')
end

bykov=dde_bykov_create(...
    'kind','bykov','parameter',point1.parameter,'degree',point1.degree,...
    'left_mesh',point1.mesh,'left_profile',point1.profile,...
    'left_period',point1.period,'left_x1',point1.x1,'left_x2',point1.x2,...
    'left_gamma_v',point1.gamma_v,'left_omega_v',point1.omega_v,'left_gamma_w',point1.gamma_w,'left_omega_w',point1.omega_w,...
    'left_v_r',point1.v_r,'left_v_i',point1.v_i,'left_w_r',point1.w_r,'left_w_i',point1.w_i,...
    'left_alpha',point1.alpha,'left_epsilon',point1.epsilon,...
    'right_mesh',point2.mesh,'right_profile',point2.profile,...
    'right_period',point2.period,'right_x1',point2.x1,'right_x2',point2.x2,...
    'right_gamma_v',point2.gamma_v,'right_omega_v',point2.omega_v,'right_gamma_w',point2.gamma_w,'right_omega_w',point2.omega_w,...
    'right_v_r',point2.v_r,'right_v_i',point2.v_i,'right_w_r',point2.w_r,'right_w_i',point2.w_i,...
    'right_alpha',point2.alpha,'right_epsilon',point2.epsilon);


end
