function n=p_norm_bykov(point,varargin)
%% norm of point for distance measuring
% adapted to Bykov T-points
%
% function n=p_norm_bykov(point,...)
% INPUT:
%	point 
% OUTPUT:
%	n norm of point (equals sqrt(p_dot(point,point,...)))

%%
% adapted from
% (c) DDE-BIFTOOL v. 2.00, 23/11/2001
%
% $Id: p_norm.m 362 2019-07-14 15:49:40Z jansieber $
% 
%by M.Stöhr 2023/03/02
%%

hcli1=dde_comp_hcli_create('kind','hcli','parameter',point.parameter,'degree',point.degree,...
    'mesh',point.left_mesh,'profile',point.left_profile,'period',point.left_period,...
    'x1',point.left_x1,'x2',point.left_x2,'gamma_v',point.left_gamma_v,'omega_v',point.left_omega_v,...
    'gamma_w',point.left_gamma_w,'omega_w',point.left_omega_w,...
    'v_r',point.left_v_r,'v_i',point.left_v_i,'w_r',point.left_w_r,'w_i',point.left_w_i,...
    'alpha',point.left_alpha,'epsilon',point.left_epsilon);

hcli2=dde_comp_hcli_create('kind','hcli','parameter',point.parameter,'degree',point.degree,...
    'mesh',point.right_mesh,'profile',point.right_profile,'period',point.right_period,...
    'x1',point.right_x1,'x2',point.right_x2,'gamma_v',point.right_gamma_v,'omega_v',point.right_omega_v,...
    'gamma_w',point.right_gamma_w,'omega_w',point.right_omega_w,...
    'v_r',point.right_v_r,'v_i',point.right_v_i,'w_r',point.right_w_r,'w_i',point.right_w_i,...
    'alpha',point.right_alpha,'epsilon',point.right_epsilon);


n1=p_dot(hcli1,hcli1,varargin{:});
n2=p_dot(hcli2,hcli2,varargin{:});
n=sqrt(n1+n2);
end
