function [y_left,y_right,J_left,J_right]=p_dot_bykov(point1,point2,varargin)
%% Compute dot product of two periodic solutions (psol structs)
% adapted to Bykov T-points

% 2nd output J is derivative wrt to point1
% by default only the integral between profiles is taken
% point2 is remeshed if meshes are different (may make J invalid)
% optional inputs
%
% derivatives (2d-integer array [n1,n2], default [0,0]): compute scalar
%   product between n1th and n2th derivative of point1 and point2
% ind_comp (array of integers between 1 and size(point1.profile,1), default
%   is 1:size(point1.profile,1)): only include ind_comp components into
%   scalar product
% free_par_ind (array of integers between 1 and length(point1.parameter),
%   default is []): add
%   point1.parameter(free_par_ind)'*point2.parameter(free_par_ind) to scalar
%   product
% period (logical, default is false): include point1.period*point2.period
% into scalar product
%
%% adapted from
% $Id: p_dot.m 348 2019-06-19 13:09:01Z jansieber $
%
% by M. Stöhr 2023/03/02

hcli_left=dde_comp_hcli_create('kind','hcli','parameter',point1.parameter,'degree',point1.degree,...
    'mesh',point1.left_mesh,'profile',point1.left_profile,'period',point1.left_period,...
    'x1',point1.left_x1,'x2',point1.left_x2,'gamma_v',point1.left_gamma_v,'omega_v',point1.left_omega_v,...
    'gamma_w',point1.left_gamma_w,'omega_w',point1.left_omega_w,...
    'v_r',point1.left_v_r,'v_i',point1.left_v_i,'w_r',point1.left_w_r,'w_i',point1.left_w_i,...
    'alpha',point1.left_alpha,'epsilon',point1.left_epsilon);

hcli_right=dde_comp_hcli_create('kind','hcli','parameter',point1.parameter,'degree',point1.degree,...
    'mesh',point1.right_mesh,'profile',point1.right_profile,'period',point1.right_period,...
    'x1',point1.right_x1,'x2',point1.right_x2,'gamma_v',point1.right_gamma_v,'omega_v',point1.right_omega_v,...
    'gamma_w',point1.right_gamma_w,'omega_w',point1.right_omega_w,...
    'v_r',point1.right_v_r,'v_i',point1.right_v_i,'w_r',point1.right_w_r,'w_i',point1.right_w_i,...
    'alpha',point1.right_alpha,'epsilon',point1.right_epsilon);

pred_left=dde_comp_hcli_create('kind','hcli','parameter',point2.parameter,'degree',point2.degree,...
    'mesh',point2.left_mesh,'profile',point2.left_profile,'period',point2.left_period,...
    'x1',point2.left_x1,'x2',point2.left_x2,'gamma_v',point2.left_gamma_v,'omega_v',point2.left_omega_v,...
    'gamma_w',point2.left_gamma_w,'omega_w',point2.left_omega_w,...
    'v_r',point2.left_v_r,'v_i',point2.left_v_i,'w_r',point2.left_w_r,'w_i',point2.left_w_i,...
    'alpha',point2.left_alpha,'epsilon',point2.left_epsilon);

pred_right=dde_comp_hcli_create('kind','hcli','parameter',point2.parameter,'degree',point2.degree,...
    'mesh',point2.right_mesh,'profile',point2.right_profile,'period',point2.right_period,...
    'x1',point2.right_x1,'x2',point2.right_x2,'gamma_v',point2.right_gamma_v,'omega_v',point2.right_omega_v,...
    'gamma_w',point2.right_gamma_w,'omega_w',point2.right_omega_w,...
    'v_r',point2.right_v_r,'v_i',point2.right_v_i,'w_r',point2.right_w_r,'w_i',point2.right_w_i,...
    'alpha',point2.right_alpha,'epsilon',point2.right_epsilon);



%% process options
[y_left,J_left]=dde_apply({'dde_',pred_left.kind,'_dot'},hcli_left,pred_left,varargin{:});
[y_right,J_right]=dde_apply({'dde_',pred_right.kind,'_dot'},hcli_right,pred_right,varargin{:});
end
