function [pt,varfields,kind]=dde_comp_hcli_create(varargin)
%% create comp_hcli point:
% for connecting orbits limiting to equilibria whose linearizations has 
% complex conjugated pairs of
% unstable eigendirections, with nonvanishing imaginary parts

% adapted from
% $Id: dde_hcli_create.m 308 2018-10-28 15:08:12Z jansieber $
% by M.Stöhr 2023/03/02
%%
default={'kind','comp_hcli','parameter',[],'mesh',[],'degree',[],'profile',[],'period',[],...
    'x1',[],'x2',[],'gamma_v',[],'omega_v',[],'gamma_w',[],'omega_w',[],'v_r',[],'v_i',[],'w_r',[],'w_i',[],'alpha',[],'epsilon',[]};
pt=dde_set_options(default,varargin,'pass_on','point');
pt.kind='comp_hcli';
if ~isempty(pt.profile)
    pt=dde_coll_check(pt);
end
% extra line to normalize alpha's
if norm(pt.alpha)~=0
    pt.alpha=pt.alpha/norm(pt.alpha);
end
varfields=struct('profile',1,'period',1,'parameter',1,...
    'x1',1,'x2',1,'v_r',1,'v_i',1,'gamma_v',1,'omega_v',1,'w_r',1,'w_i',1,'gamma_w',1,'omega_w',1,'alpha',1);
kind='coll';
end
