function [J,res]=dde_bykov_jac_res(funcs,pt,free_par,method,varargin)
%% by M.Stöhr 2023/03/02
%
%% computes Jacobian and residual of Bykov T-point 

%% inputs/components
default={'pref',pt,'collocation_parameters',method.collocation_parameters,...
    'phase_condition',method.phase_condition};
options=dde_set_options(default,varargin,'pass_on');
previous=options.pref;
if isempty(options.pref)
    previous_left=dde_comp_hcli_create('kind','hcli','parameter',pt.parameter,'degree',pt.degree,...
    'mesh',pt.left_mesh,'profile',pt.left_profile,'period',pt.left_period,...
    'x1',pt.left_x1,'x2',pt.left_x2,'gamma_v',pt.left_gamma_v,'omega_v',pt.left_omega_v,...
    'gamma_w',pt.left_gamma_w,'omega_w',pt.left_omega_w,...
    'v_r',pt.left_v_r,'v_i',pt.left_v_i,'w_r',pt.left_w_r,'w_i',pt.left_w_i,...
    'alpha',pt.left_alpha,'epsilon',pt.left_epsilon);

    previous_right=dde_comp_hcli_create('kind','hcli','parameter',pt.parameter,'degree',pt.degree,...
    'mesh',pt.right_mesh,'profile',pt.right_profile,'period',pt.right_period,...
    'x1',pt.right_x1,'x2',pt.right_x2,'gamma_v',pt.right_gamma_v,'omega_v',pt.right_omega_v,...
    'gamma_w',pt.right_gamma_w,'omega_w',pt.right_omega_w,...
    'v_r',pt.right_v_r,'v_i',pt.right_v_i,'w_r',pt.right_w_r,'w_i',pt.right_w_i,...
    'alpha',pt.right_alpha,'epsilon',pt.right_epsilon);

else
    previous_left=dde_comp_hcli_create('kind','hcli','parameter',previous.parameter,'degree',previous.degree,...
        'mesh',previous.left_mesh,'profile',previous.left_profile,'period',previous.left_period,...
        'x1',previous.left_x1,'x2',previous.left_x2,'gamma_v',previous.left_gamma_v,'omega_v',previous.left_omega_v,...
        'gamma_w',previous.left_gamma_w,'omega_w',previous.left_omega_w,...
        'v_r',previous.left_v_r,'v_i',previous.left_v_i,'w_r',previous.left_w_r,'w_i',previous.left_w_i,...
        'alpha',previous.left_alpha,'epsilon',previous.left_epsilon);

    previous_right=dde_comp_hcli_create('kind','hcli','parameter',previous.parameter,'degree',previous.degree,...
        'mesh',previous.right_mesh,'profile',previous.right_profile,'period',previous.right_period,...
        'x1',previous.right_x1,'x2',previous.right_x2,'gamma_v',previous.right_gamma_v,'omega_v',previous.right_omega_v,...
        'gamma_w',previous.right_gamma_w,'omega_w',previous.right_omega_w,...
        'v_r',previous.right_v_r,'v_i',previous.right_v_i,'w_r',previous.right_w_r,'w_i',previous.right_w_i,...
        'alpha',previous.right_alpha,'epsilon',previous.right_epsilon);
end


hcli1=dde_comp_hcli_create('kind','hcli','parameter',pt.parameter,'degree',pt.degree,...
    'mesh',pt.left_mesh,'profile',pt.left_profile,'period',pt.left_period,...
    'x1',pt.left_x1,'x2',pt.left_x2,'gamma_v',pt.left_gamma_v,'omega_v',pt.left_omega_v,...
    'gamma_w',pt.left_gamma_w,'omega_w',pt.left_omega_w,...
    'v_r',pt.left_v_r,'v_i',pt.left_v_i,'w_r',pt.left_w_r,'w_i',pt.left_w_i,...
    'alpha',pt.left_alpha,'epsilon',pt.left_epsilon);

hcli2=dde_comp_hcli_create('kind','hcli','parameter',pt.parameter,'degree',pt.degree,...
    'mesh',pt.right_mesh,'profile',pt.right_profile,'period',pt.right_period,...
    'x1',pt.right_x1,'x2',pt.right_x2,'gamma_v',pt.right_gamma_v,'omega_v',pt.right_omega_v,...
    'gamma_w',pt.right_gamma_w,'omega_w',pt.right_omega_w,...
    'v_r',pt.right_v_r,'v_i',pt.right_v_i,'w_r',pt.right_w_r,'w_i',pt.right_w_i,...
    'alpha',pt.right_alpha,'epsilon',pt.right_epsilon);




%%
[J_h1,res_h1]=dde_comp_hcli_jac_res(funcs,hcli1,free_par,method,'pref',previous_left);
[J_h2,res_h2]=dde_comp_hcli_jac_res(funcs,hcli2,free_par,method,'pref',previous_right);

[L1,M1]=size(J_h1);
[L2,M2]=size(J_h2);

nb_par=length(free_par); % number of free parameters
m=pt.degree;
n1=size(pt.left_profile,1); % system dimension
n2=size(pt.right_profile,1); % system dimension

l1=(length(pt.left_mesh)-1)/m; % number of intervals
l2=(length(pt.right_mesh)-1)/m; % number of intervals

M1=M1-nb_par;
M2=M2-nb_par;
M=M1+M2+nb_par;

%%
J=zeros(L1+L2,M);

% entries for free parameters
J(1:L1,1:nb_par)=J_h1(:,n1*m*l1+n1+1+1:n1*m*l1+n1+1+nb_par);
J(L1+1:L1+L2,1:nb_par)=J_h2(:,n2*m*l2+n1+1+1:n2*m*l2+n2+1+nb_par);

% other entries
J(1:L1,nb_par+1:M1+nb_par)=[J_h1(:,1:n1*m*l1+n1+1), J_h1(:,n1*m*l1+n1+1+nb_par+1:end)];
J(L1+1:L1+L2,M1+nb_par+1:M)=[J_h2(:,1:n2*m*l2+n2+1), J_h2(:,n2*m*l2+n2+1+nb_par+1:end)];


res=[res_h1;res_h2];

end
