function [pt,varfields,kind]=dde_bykov_create(varargin)
%% create Bykov T-point
% 1. consisting of two connecting orbits of codimension 1
% and
% 2. the linearization of the equilibria of the connecting orbits 
% have positive eigenvalues that are not real

% adapted from
% $Id: dde_hcli_create.m 308 2018-10-28 15:08:12Z jansieber $
% by M.Stöhr 2023/03/02
%%
default={'kind','bykov','parameter',[],'degree',[],...
    'left_mesh',[],'left_profile',[],'left_period',[],...
    'left_x1',[],'left_x2',[],'left_gamma_v',[],'left_omega_v',[],'left_gamma_w',[],'left_omega_w',[],...
    'left_v_r',[],'left_v_i',[],'left_w_r',[],'left_w_i',[],'left_alpha',[],'left_epsilon',[],...
    'right_mesh',[],'right_profile',[],'right_period',[],...
    'right_x1',[],'right_x2',[],'right_gamma_v',[],'right_omega_v',[],'right_gamma_w',[],'right_omega_w',[],...
    'right_v_r',[],'right_v_i',[],'right_w_r',[],'right_w_i',[],'right_alpha',[],'right_epsilon',[]};
pt=dde_set_options(default,varargin,'pass_on','point');
pt.kind='bykov';
if ~isempty(pt.left_profile)
    left_pt=dde_comp_hcli_create('mesh',pt.left_mesh,'profile',pt.left_profile,'degree',pt.degree);
    left_pt=dde_coll_check(left_pt);
end
if ~isempty(pt.right_profile)
    right_pt=dde_comp_hcli_create('mesh',pt.right_mesh,'profile',pt.right_profile,'degree',pt.degree);
    right_pt=dde_coll_check(right_pt);
end
% extra line to normalize alpha's
if norm(pt.left_alpha)~=0
    pt.left_alpha=pt.left_alpha/norm(pt.left_alpha);
end
if norm(pt.right_alpha)~=0
    pt.right_alpha=pt.right_alpha/norm(pt.right_alpha);
end

varfields=struct('parameter',1,'left_profile',1,'left_period',1,'left_x1',1,'left_x2',1, ...
    'left_v_r',1,'left_v_i',1,'left_gamma_v',1,'left_omega_v',1,'left_w_r',1,'left_w_i',1,'left_gamma_w',1,'left_omega_w',1,'left_alpha',1,...
    'right_profile',1,'right_period',1,'right_x1',1,'right_x2',1, ...
    'right_v_r',1,'right_v_i',1,'right_gamma_v',1,'right_omega_v',1,'right_w_r',1,'right_w_i',1,'right_gamma_w',1,'right_omega_w',1,'right_alpha',1);
kind='coll';



end
