function plot_indices(br,varargin)

%% 
% plot indices of points along branch
% varargin are x- and y-measures and frequency of plotted labels (plot_every)


%% check which varargin are given
    switch nargin
        case 1  % only branch is given, use plot measure as in branch-struct, default plot_every to 2
            if ~isempty(br.method.continuation.plot_measure)
                xp = br.method.continuation.plot_measure.x;
                yp = br.method.continuation.plot_measure.y;
            else
                warning('no plot measures given or defined in the branch struct, plot with default mesasure')
                [xp,yp] = df_measr(0,br,'psol');
            end
            plot_every = 2;
        case 2  % branch and plot_every given
            if ~isempty(br.method.continuation.plot_measure)
                xp = br.method.continuation.plot_measure.x;
                yp = br.method.continuation.plot_measure.y;
            else
                warning('no plot measures given or defined in the branch struct')
            end
            if isnumeric(varargin{1}) 
                plot_every = floor(varargin{1});
            else
                plot_every = 2;
                warning('second argument (plot_every) must be integer, default to 2')
            end
        case 3  %plot measures are given, default plot_every to 2
            xp = varargin{1};
            yp = varargin{2};
            plot_every = 2;
        case 4
            xp = varargin{1};
            yp = varargin{2};
            plot_every = varargin{3};
        otherwise
            warning('no (or too many) input arguments given');      
    end
    
%% stuff I tried but then I found the convinience function p_measur()    
%     if and(ischar(xp.func),~isempty(xp.func))  % check if x-measure is a function handle, otherwise create it
%         xfunc = str2func(xp.func);
%     elseif ~isempty(xp.func)
%         xfunc = xp.func;
%     else
%         xfunc = @(x) x;
%     end        
%     
%     if and(ischar(yp.func),~isempty(yp.func))  % check if y-measure is a function handle, otherwise create it
%         yfunc = str2func(yp.func);
%     elseif ~isempty(yp.func)
%         yfunc = yp.func;
%     else
%         yfunc = @(x) x;
%     end   

%% plot labels
    hold on;
    for i = 1:plot_every:length(br.point)
        xvalue = p_measur(br.point(i),xp);
        yvalue = p_measur(br.point(i),yp);
        plot(xvalue,yvalue,'kx');
        text(xvalue,yvalue,[' ' int2str(i)],'VerticalAlignment','top');
    end
end

