%% test NDDE modifications - generation of r.h.s.
%
% This file demonstrates how one can use the symbolic toolbox to
% automatically create the right-hand side and its first directional
% derivatives using the symbolic toolbox, using the routines in
% |ddebiftool_extra_symbolic|. The example is the laser model by Hessel et
% al.
%
% $Id: gen_sym_ddae.m 372 2019-08-27 22:13:34Z jansieber $
%%
clear
base=[pwd(),'/../dde_biftool/'];
addpath([base,'ddebiftool'],[base,'ddebiftool_extra_symbolic']);
if dde_isoctave()
    pkg load symbolic
end
%% Set number of delays and create parameter names as strings
parnames={'delta','h','eta','phi','inj','tau','s','T'};


%% Create symbols for parameters, states and delayed states
% The array |par| is the array of symbols in the same order as parnames.
% Due to the following two lines we may, for example, use either tau or
% par(1) to refer to the delay.
syms(parnames{:});       % create symbols for parameters
par=cell2sym(parnames);  % now tau is par(1) etc
for i=1:length(parnames)
    assume(par(i),'real');
end
syms E1r E1i E1rtau E1itau Y1r Y1i Y1rtau Y1itau E2r E2i E2rtau E2itau Y2r Y2i Y2rtau Y2itau real % create symbols for E(t) E(t-tau), n(t)
E1=E1r+1i*E1i;
E1tau=E1rtau+1i*E1itau;
Y1=Y1r+1i*Y1i;
Y1tau=Y1rtau+1i*Y1itau;
E2=E2r+1i*E2i;
E2tau=E2rtau+1i*E2itau;
Y2=Y2r+1i*Y2i;
Y2tau=Y2rtau+1i*Y2itau;

dE1_dt=-((-1+1i*(s*conj(E1)*E1-delta))*E1+h*Y1);
dE2_dt=-((-1+1i*(s*conj(E2)*E2-delta))*E2+h*Y2);
Y1_a=eta*exp(1i*phi)*(E2tau-Y2tau)+sqrt(1-eta^2)*inj-Y1;
Y2_a=eta*exp(1i*phi)*(E1tau-Y1tau)+sqrt(1-eta^2)*inj-Y2;

dE1r_dt=real(dE1_dt);
dE1i_dt=imag(dE1_dt);
dE2r_dt=real(dE2_dt);
dE2i_dt=imag(dE2_dt);

Y1r_a=real(Y1_a);
Y1i_a=imag(Y1_a);
Y2r_a=real(Y2_a);
Y2i_a=imag(Y2_a);

%% Differentiate and generate code, exporting it to sym_LangKobayashi
[fstr,derivs]=dde_sym2funcs(...
    [dE1r_dt;dE1i_dt;Y1r_a;Y1i_a;dE2r_dt;dE2i_dt;Y2r_a;Y2i_a],... % n x 1 array of derivative symbolic expressions
    [E1r,E1rtau; E1i,E1itau; Y1r,Y1rtau; Y1i,Y1itau;  E2r,E2rtau;E2i,E2itau; Y2r,Y2rtau; Y2i,Y2itau],... % n x (ntau+1) array of symbols for states (current & delayed)
    par,...            % 1 x np (or np x 1) array of symbols used for parameters
    'filename','sym_APE',... % optional argument specifying output file
    'directional_derivative',true,...
    'maxorder',2);
