*----------------------------------------------------
*     created by Lara De Nardo, March 15, 2011
*     input: x, Q2, W2
*     output: sigmatot [barn], F2
*----------------------------------------------------
      program gdfit
      double precision dx,dq2,dw2,sigmatot,F2
      double precision dsigmatot,dF2
      double precision aprmass
      character*1 target
      parameter (aprmass=0.938272029d0)

      target='p'
      dx=0.005d0
      dq2=500d0
      dw2=aprmass*aprmass+dq2*(1.d0/dx-1.d0)

      !
      !dw2=3000d0
      !dq2=0.0d0
      !dx=0.0d0


      write(*,*) 'x=',dx
      write(*,*) 'Q2=',dq2,' [GeV2]'
      write(*,*)'w2=',dw2, ' [GeV2]' 

      call gd_fit_11(dx,dQ2,dW2,target,sigmatot,F2,dsigmatot,dF2)
      
      write(*,*) 'F2= ',F2,' +- ' , dF2
      write(*,*) 'sigmatot= ',sigmatot,' +- ', dsigmatot, '[barn]'
            
      end


c------------------------------------------------------------------------
       subroutine gd_fit_11(dx,dQ2,dW2,target,sigmatot,F2,dsigmatot,dF2)
      
      IMPLICIT NONE

      CHARACTER*1 TARGET
      DOUBLE PRECISION PARAM(23),COV(23,23)
      DOUBLE PRECISION F2P,F2R
      DOUBLE PRECISION XP,XR,CP,CR,AP,AR,BP,BR,t,dQ2,dx,dW2
      double precision alpha_em,aprmass,pi,hbarc2,gam2
      double precision sigmatot,F2
      double precision dsigmatot,dF2
      parameter (
     c     alpha_em=0.007297352568,
     c     aprmass=0.938272029d0,
     c     pi=3.141592653590,
     c     hbarc2=389.379323d0)
      if (target.eq.'p') then

         param( 1)=   0.506308
         param( 2)=  34.747207
         param( 3)=   0.031904
         param( 4)=   1.373708
         param( 5)=   0.065270
         param( 6)=  -0.118952
         param( 7)=  -0.478299
         param( 8)=   1.353454
         param( 9)=   1.083312
         param( 10)=  2.655665
         param( 11)=  1.770584
         param( 12)=  0.363820
         param( 13)=  0.121055
         param( 14)=  1.166300
         param( 15)=  0.342481
         param( 16)=  1.060336
         param( 17)=  0.516432
         param( 18)=-10.408001
         param( 19)= 14.857355
         param( 20)=  0.077394
         param( 21)=  1.363307
         param( 22)=  2.255811
         param( 23)=  2.208822

      elseif (target.eq.'d') then
         param( 1)=   0.425860
         param( 2)=   0.000077
         param( 3)=   0.229273
         param( 4)=   2.651400
         param( 5)=   0.065270
         param( 6)=  -0.428739
         param( 7)=   0.289067
         param( 8)=   0.393099
         param( 9)= -27.211610
         param( 10)= 30.687466
         param( 11)=  0.045766
         param( 12)=  0.000734
         param( 13)=  0.974080
         param( 14)=  0.872252
         param( 15)=  0.298613
         param( 16)=  3.615080
         param( 17)=  1.145511
         param( 18)=  1.986588
         param( 19)=  7.149559
         param( 20)=  0.934952
         param( 21)=  1.031558
         param( 22)= 26.358899
         param( 23)=  3.024411

      else
         write(*,*) 'target unknown- STOP'
         stop
      endif
      
      t=dlog((dQ2+param(4))/param(5)) / log(param(4)/param(5))
      t=dlog(t)

      if (dQ2.ne.0.d0) then         
         XP=(dQ2+param(2))/(dQ2/dx+param(2))
         XR=(dQ2+param(3))/(dQ2/dx+param(3))
      else
         XP=1.d0+(dW2-aprmass*aprmass)/(dQ2+param(2))
         XR=1.d0+(dW2-aprmass*aprmass)/(dQ2+param(3))
         XP=1.d0/XP
         XR=1.d0/XR
      endif

      AP=param( 6)+(param( 6)-param( 7))*(1.d0/(1.d0+t**param( 8))-1.d0)
      CP=param(12)+(param(12)-param(13))*(1.d0/(1.d0+t**param(14))-1.d0)

      BP=param( 9)+param(10)*t**param(11)
      AR=param(15)+param(16)*t**param(17)
      BR=param(18)+param(19)*t**param(20)
      CR=param(21)+param(22)*t**param(23)

      F2P=CP*(XP**AP)*(1.d0-dX)**BP
      F2R=CR*(XR**AR)*(1.d0-dX)**BR
      
      if (dQ2.ne.0.d0) gam2=4.d0*aprmass*aprmass*dx*dx/dQ2   
      if (dQ2.eq.0.d0) gam2=0.d0

      SigmaTot=4.d0*pi*pi*alpha_em*(1.d0+gam2)*(F2P+F2R)/(dQ2+param(1))/
     c     (1.d0-dx)*hbarc2

      F2=(F2P+F2R)*dQ2/(dQ2+param(1))

      call covariance(target,cov)
      
      call allm_uncertainty(param,dx,dq2,dW2,cov,dF2,dSigmaTot)

      return
      end

c------------------------------------------------------------------------
      subroutine allm_uncertainty(param,dx,dq2,dW2,cov,dF2,dSigmaTot)
      double precision param(23),dx,dW2,dq2,dfd(23),cov(23,23),t,F2P,F2R
      double precision xp,xr,CP,CR,AP,AR,BP,BR,dF2,alpha_em,pi,aprmass,
     c     dsigmatot,sigmatotfac,hbarc2
      parameter (alpha_em=0.007297352568d0,pi=3.141592653590d0,
     x     aprmass=0.938272029d0,hbarc2=389.379323d0)
    
      if (dQ2.ne.0.d0) gam2=4.d0*aprmass*aprmass*dx*dx/dQ2   
      if (dQ2.eq.0.d0)  gam2=0.d0
    
      if (dQ2.ne.0.d0) then
      t=dlog((dQ2+param(4))/param(5)) / log(param(4)/param(5))
      t=dlog(t)

      XP=1.d0+(dW2-aprmass*aprmass)/(dQ2+param(2))
      XR=1.d0+(dW2-aprmass*aprmass)/(dQ2+param(3))
      XP=1.d0/XP
      XR=1.d0/XR

      AP=param( 6)+(param( 6)-param( 7))*(1.d0/(1.d0+t**param( 8))-1.d0)
      CP=param(12)+(param(12)-param(13))*(1.d0/(1.d0+t**param(14))-1.d0)

      BP=param( 9)+param(10)*t**param(11)
      AR=param(15)+param(16)*t**param(17)
      BR=param(18)+param(19)*t**param(20)
      CR=param(21)+param(22)*t**param(23)
      
      F2P=CP*(XP**AP)*(1.d0-dX)**BP
      F2R=CR*(XR**AR)*(1.d0-dX)**BR
      


      dfd(1)=-(F2P+F2R)/(dQ2+param(1))/(dQ2+param(1))
      dFd(2)=AP*XP*F2P*(dW2-aprmass*aprmass)/(dQ2+param(1))
     c     /(dQ2+param(2))/(dQ2+param(2))
      dFd(3)=AR*XR*F2R*(dW2-aprmass*aprmass)/(dQ2+param(1))
     c     /(dQ2+param(3))/(dQ2+param(3))
      dFd(4)=( 
     c     -(xp**ap) * ((1.d0-dx)**BP) * (param(12)-param(13)) 
     c     * param(14) * 
     c     (t**(param(14)-1.d0)) / (1.d0+t**param(14)) / 
     c     (1.d0+t**param(14))
     c     -
     c     F2P * dlog(XP) * (param(6)-param(7)) * param(8) * 
     c     (t**(param(8)-1.d0)) / (1.d0+t**param(8)) /(1.d0+t**param(8))
     c     +
     c     F2P * dlog(1.d0-dx) * param(10) * param(11) *
     c     (t**(param(11)-1.d0))
     c     +
     c     (XR**AR) * ((1.d0-dx)**BR) * param(22) * param(23) * 
     c     (t**(param(23)-1.d0))
     c     +
     c     F2R * dlog(XR) *param(16) * param(17) * (t**(param(17)-1.d0))
     c     +
     c     F2R * dlog(1.d0-dx) * param(19) * param(20) * 
     c     (t**(param(20)-1.d0))
     c     )*
     c     (
     c     1.d0/(dQ2+param(4))/(dlog((dQ2+param(4))/param(5)))-
     c     1.d0/(param(4))/(dlog(param(4)/param(5)))
     c     )
     c     /(dQ2+param(1))
      dFd(5)=  ( 
     c     -(XP**AP) * ((1.d0-dx)**BP) *(param(12)-param(13))*param(14)*
     c     (t**(param(14)-1.d0))/(1.d0+t**param(14))/(1.d0+t**param(14))
     c     -
     c     F2P * dlog(XP) * (param(6)-param(7)) * param(8) *
     c     (t**(param(8)-1.d0))
     c     /(1.d0+t**param(8))/(1.d0+t**param(8))
     c     +
     c     F2P * dlog(1.d0-dx) * param(10) * param(11) * 
     c     (t**(param(11)-1.d0))
     c     +
     c     (XR**AR) * ((1.d0-dx)**BR) * param(22) * param(23)*
     c     (t**(param(23)-1.d0))
     c     +
     c     F2R * dlog(XR) *param(16) * param(17) * (t**(param(17)-1.d0))
     c     +
     c     F2R * dlog(1.d0-dx) * param(19) * param(20) *
     c     (t**(param(20)-1.d0))
     c     )
     c     *
     c     (
     c     1.d0/(dlog(param(4)/param(5)))-
     c     1.d0/dlog((dQ2+param(4))/param(5))
     c     )
     c     /(dQ2+param(1))/param(5)
      dFd(6)=   F2P * dlog(XP) /(dQ2+param(1))/(1.d0+t**param(8))
      dFd(7)=   F2P * dlog(XP) /(dQ2+param(1))*
     c     (1.d0-1.d0/(1.d0+t**param(8)))
      dFd(8)= - F2P * (param(6)-param(7)) *(t**param(8)) * dlog(t) 
     c     * dlog(XP)
     c     /(dQ2+param(1))/(1.d0+t**param(8))/(1.d0+t**param(8))
      dFd(9)=   F2P * dlog(1.d0-dx) / (dQ2+param(1))
      dFd(10)=  F2P * (t**Param(11)) * dlog(1.d0-dx)/ (dQ2+param(1))
      dFd(11)=  F2P * dlog(1.d0-dx)*param(10)* (t**Param(11))*dlog(t)/
     c     (dQ2+param(1))
      dFd(12)= (XP**AP) * ((1.d0-dX)**BP)/(1.d0+t**param(14))/
     c     (dQ2+param(1))
      dFd(13)=(XP**AP) * ((1.d0-dX)**BP)*(1.d0-1.d0/(1.d0+t**param(14)))
     c     / (dQ2+param(1))
      dFd(14)=- (XP**AP) * ((1.d0-dX)**BP)*(param(12)-param(13)) *
     c     (t**param(14))
     c     *dlog(t)/(1.d0+t**param(14))/(1.d0+t**param(14))
     c     / (dQ2+param(1))
      dFd(15)= F2R * dlog(XR)/ (dQ2+param(1))
      dFd(16)= F2R * dlog(XR) * (t**param(17))/ (dQ2+param(1))
      dFd(17)= F2R * dlog(XR) * param(16) * (t**param(17))* dlog(t)/ 
     c     (dQ2+param(1))
      dFd(18)= F2R * dlog(1.d0-dx)/ (dQ2+param(1))
      dFd(19)= F2R * dlog(1.d0-dx) * (t**param(20))/ (dQ2+param(1))
      dFd(20)= F2R * dlog(1.d0-dx) * param(19)*(t**param(20))*dlog(t)/
     c     (dQ2+param(1))
      dFd(21)= (XR**AR)* ((1.d0-dx)**BR)/ (dQ2+param(1))
      dFd(22)= (XR**AR)* ((1.d0-dx)**BR)*(t**param(23))/ (dQ2+param(1))
      dFd(23)= (XR**AR)* ((1.d0-dx)**BR)*param(22)*(t**param(23))*
     c     dlog(t)/ (dQ2+param(1))
      
      sigmatotfac=16.d0*pi*pi*pi*pi*alpha_em*alpha_em*(1.d0+gam2)*
     c     (1.d0+gam2)/(1.d0-dx)/(1.d0-dx)
      df2=0.d0
      dsigmatot=0.d0
      
      do i=1,23
         do j=1,23
            df2=df2+dQ2*dQ2*dfd(i)*dfd(j)*cov(i,j)
            dsigmatot=dsigmatot+sigmatotfac*dfd(i)*dfd(j)*cov(i,j)
         enddo
      enddo
      df2=sqrt(df2)
      dsigmatot=sqrt(dsigmatot)*hbarc2
      goto 10
      endif
      if (dQ2.eq.0.d0) then
         do i=1,23
            dfd(i)=0.d0
         enddo


       dFd(1)=-4.d0*pi*pi*alpha_em*(1.d0/param(1)/param(1))*(
     c        (param(12)*((param(2)+dW2-aprmass*aprmass)
     c        /param(2))**(-param(6))+                                           
     c        param(21)*((param(3)+dW2-aprmass*aprmass)/
     c        param(3))**(-param(15))))
    

         dFd(2)=4.d0*pi*pi*alpha_em*(1.d0/param(1))*param(12)*param(6)*
     c        ((param(2)+dW2-aprmass*aprmass)/param(2))**(-param(6)-1.)*
     c        (dW2-aprmass*aprmass)/param(2)/param(2)                     
         dFd(3)=4.d0*pi*pi*alpha_em*(1.d0/param(1))*param(21)*param(15)*
     c       ((param(3)+dW2-aprmass*aprmass)/param(3))**(-param(15)-1.)* 
     c        (dW2-aprmass*aprmass)/param(3)/param(3)

         dFd(6)=-4.d0*pi*pi*alpha_em*(1.d0/param(1))*param(12)*
     c        ((param(2)+dW2-aprmass*aprmass)/param(2))**(-param(6))*
     c        dlog((param(2)+dW2-aprmass*aprmass)/param(2))


         dFd(12)=4.d0*pi*pi*alpha_em*(1.d0/param(1))*
     c        ((param(2)+dW2-aprmass*aprmass)/param(2))**(-param(6))

         dFd(15)=-4.d0*pi*pi*alpha_em*(1.d0/param(1))*param(21)*
     c        ((param(3)+dW2-aprmass*aprmass)/param(3))**(-param(15))*
     c        dlog((param(3)+dW2-aprmass*aprmass)/param(3))

         dFd(21)=4.d0*pi*pi*alpha_em*(1.d0/param(1))*
     c        ((param(3)+dW2-aprmass*aprmass)/param(3))**(-param(15))


      df2=0.d0
      dsigmatot=0.d0
      do i=1,23
         do j=1,23
            dsigmatot=dsigmatot+dfd(i)*dfd(j)*cov(i,j)
         enddo
      enddo

      dsigmatot=sqrt(dsigmatot)*hbarc2
      endif

 10   return
      end



c------------------------------------------------------------------
      subroutine covariance(target,cov)
      character*1 target
      double precision cov(23,23), covp(23,23),covd(23,23)

      data covp/
     c 0.557E-03,-0.451E-02,-0.200E-04,-0.316E-02, 0.000E+00,-0.505E-04,
     c 0.221E-03, 0.229E-02,-0.974E-04,-0.357E-02, 0.137E-02, 0.254E-03,
     c-0.159E-03,-0.621E-03,-0.340E-03,-0.583E-07, 0.347E-03,-0.295E-03,
     c-0.367E-03, 0.889E-04, 0.246E-03,-0.337E-02, 0.253E-02,-0.451E-02,
     c 0.656E+01,-0.602E-02,-0.343E+00, 0.000E+00, 0.195E-02, 0.168E-01,
     c 0.152E+00, 0.395E-01,-0.355E+00, 0.243E+00, 0.862E-02, 0.647E-02,
     c 0.240E+00, 0.634E-02,-0.716E-01, 0.321E-02,-0.707E-01,-0.587E-01,
     c 0.224E-02, 0.554E-01,-0.560E+00, 0.240E+00,-0.200E-04,-0.602E-02,
     c 0.686E-04, 0.633E-03, 0.000E+00, 0.128E-04,-0.545E-04,-0.440E-03,
     c-0.135E-03, 0.613E-03,-0.635E-03, 0.149E-04,-0.466E-04,-0.649E-03,
     c 0.111E-03,-0.330E-04, 0.799E-04, 0.541E-04, 0.165E-03, 0.196E-05,
     c-0.402E-03, 0.104E-02,-0.918E-03,-0.316E-02,-0.343E+00, 0.633E-03,
     c 0.122E+00, 0.000E+00, 0.508E-03,-0.753E-02,-0.688E-01, 0.801E-02,
     c 0.123E+00,-0.540E-01,-0.178E-02,-0.250E-02,-0.505E-01, 0.180E-02,
     c 0.163E-01,-0.112E-01, 0.157E-01, 0.214E-01,-0.190E-02,-0.802E-02,
     c 0.163E+00,-0.775E-01, 0.000E+00, 0.000E+00, 0.000E+00, 0.000E+00,
     c 0.000E+00, 0.000E+00, 0.000E+00, 0.000E+00, 0.000E+00, 0.000E+00,
     c 0.000E+00, 0.000E+00, 0.000E+00, 0.000E+00, 0.000E+00, 0.000E+00,
     c 0.000E+00, 0.000E+00, 0.000E+00, 0.000E+00, 0.000E+00, 0.000E+00,
     c 0.000E+00,-0.505E-04, 0.195E-02, 0.128E-04, 0.508E-03, 0.000E+00,
     c 0.169E-04,-0.451E-04,-0.438E-03, 0.491E-04, 0.569E-03,-0.160E-03,
     c 0.492E-05,-0.207E-04,-0.301E-03, 0.859E-04,-0.443E-04,-0.771E-04,
     c 0.233E-04, 0.637E-04,-0.182E-04, 0.470E-04, 0.395E-03,-0.370E-03,
     c 0.221E-03, 0.168E-01,-0.545E-04,-0.753E-02, 0.000E+00,-0.451E-04,
     c 0.501E-03, 0.431E-02,-0.598E-03,-0.757E-02, 0.320E-02, 0.895E-04,
     c 0.200E-03, 0.314E-02,-0.188E-03,-0.823E-03, 0.745E-03,-0.895E-03,
     c-0.128E-02, 0.123E-03, 0.470E-03,-0.957E-02, 0.485E-02, 0.229E-02,
     c 0.152E+00,-0.440E-03,-0.688E-01, 0.000E+00,-0.438E-03, 0.431E-02,
     c 0.413E-01,-0.423E-02,-0.712E-01, 0.302E-01, 0.965E-03, 0.132E-02,
     c 0.300E-01,-0.180E-02,-0.815E-02, 0.646E-02,-0.838E-02,-0.117E-01,
     c 0.120E-02, 0.391E-02,-0.893E-01, 0.445E-01,-0.974E-04, 0.395E-01,
     c-0.135E-03, 0.801E-02, 0.000E+00, 0.491E-04,-0.598E-03,-0.423E-02,
     c 0.825E-02, 0.518E-02, 0.715E-02, 0.507E-04,-0.384E-03,-0.238E-02,
     c 0.103E-03,-0.154E-03,-0.187E-02,-0.789E-04, 0.892E-03,-0.490E-04,
     c 0.175E-02, 0.522E-02, 0.282E-02,-0.357E-02,-0.355E+00, 0.613E-03,
     c 0.123E+00, 0.000E+00, 0.569E-03,-0.757E-02,-0.712E-01, 0.518E-02,
     c 0.132E+00,-0.552E-01,-0.192E-02,-0.228E-02,-0.524E-01, 0.223E-02,
     c 0.160E-01,-0.115E-01, 0.149E-01, 0.211E-01,-0.222E-02,-0.681E-02,
     c 0.164E+00,-0.773E-01, 0.137E-02, 0.243E+00,-0.635E-03,-0.540E-01,
     c 0.000E+00,-0.160E-03, 0.320E-02, 0.302E-01, 0.715E-02,-0.552E-01,
     c 0.417E-01, 0.102E-02, 0.884E-03, 0.228E-01,-0.538E-03,-0.943E-02,
     c 0.286E-02,-0.940E-02,-0.105E-01, 0.734E-03, 0.907E-02,-0.819E-01,
     c 0.490E-01, 0.254E-03, 0.862E-02, 0.149E-04,-0.178E-02, 0.000E+00,
     c 0.492E-05, 0.895E-04, 0.965E-03, 0.507E-04,-0.192E-02, 0.102E-02,
     c 0.196E-03,-0.137E-03,-0.673E-03,-0.142E-05,-0.277E-03, 0.102E-03,
     c-0.285E-03,-0.253E-03, 0.250E-04, 0.385E-03,-0.262E-02, 0.140E-02,
     c-0.159E-03, 0.647E-02,-0.466E-04,-0.250E-02, 0.000E+00,-0.207E-04,
     c 0.200E-03, 0.132E-02,-0.384E-03,-0.228E-02, 0.884E-03,-0.137E-03,
     c 0.267E-03, 0.241E-02,-0.527E-04,-0.215E-03, 0.300E-03,-0.243E-03,
     c-0.473E-03, 0.347E-04, 0.710E-05,-0.285E-02, 0.140E-02,-0.621E-03,
     c 0.240E+00,-0.649E-03,-0.505E-01, 0.000E+00,-0.301E-03, 0.314E-02,
     c 0.300E-01,-0.238E-02,-0.524E-01, 0.228E-01,-0.673E-03, 0.241E-02,
     c 0.390E-01,-0.103E-02,-0.649E-02, 0.419E-02,-0.624E-02,-0.887E-02,
     c 0.814E-03, 0.192E-02,-0.659E-01, 0.309E-01,-0.340E-03, 0.634E-02,
     c 0.111E-03, 0.180E-02, 0.000E+00, 0.859E-04,-0.188E-03,-0.180E-02,
     c 0.103E-03, 0.223E-02,-0.538E-03,-0.142E-05,-0.527E-04,-0.103E-02,
     c 0.593E-03,-0.534E-03,-0.285E-03, 0.126E-05, 0.126E-03,-0.918E-04,
     c 0.311E-03, 0.741E-03,-0.150E-02,-0.583E-07,-0.716E-01,-0.330E-04,
     c 0.163E-01, 0.000E+00,-0.443E-04,-0.823E-03,-0.815E-02,-0.154E-03,
     c 0.160E-01,-0.943E-02,-0.277E-03,-0.215E-03,-0.649E-02,-0.534E-03,
     c 0.409E-02,-0.955E-03, 0.315E-02, 0.364E-02,-0.146E-03,-0.179E-02,
     c 0.282E-01,-0.112E-01, 0.347E-03, 0.321E-02, 0.799E-04,-0.112E-01,
     c 0.000E+00,-0.771E-04, 0.745E-03, 0.646E-02,-0.187E-02,-0.115E-01,
     c 0.286E-02, 0.102E-03, 0.300E-03, 0.419E-02,-0.285E-03,-0.955E-03,
     c 0.193E-02,-0.987E-03,-0.162E-02, 0.283E-03,-0.135E-02,-0.111E-01,
     c 0.487E-02,-0.295E-03,-0.707E-01, 0.541E-04, 0.157E-01, 0.000E+00,
     c 0.233E-04,-0.895E-03,-0.838E-02,-0.789E-04, 0.149E-01,-0.940E-02,
     c-0.285E-03,-0.243E-03,-0.624E-02, 0.126E-05, 0.315E-02,-0.987E-03,
     c 0.393E+00,-0.386E+00, 0.198E-02,-0.120E-02, 0.255E-01,-0.101E-01,
     c-0.367E-03,-0.587E-01, 0.165E-03, 0.214E-01, 0.000E+00, 0.637E-04,
     c-0.128E-02,-0.117E-01, 0.892E-03, 0.211E-01,-0.105E-01,-0.253E-03,
     c-0.473E-03,-0.887E-02, 0.126E-03, 0.364E-02,-0.162E-02,-0.386E+00,
     c 0.393E+00,-0.238E-02,-0.260E-02, 0.329E-01,-0.161E-01, 0.889E-04,
     c 0.224E-02, 0.196E-05,-0.190E-02, 0.000E+00,-0.182E-04, 0.123E-03,
     c 0.120E-02,-0.490E-04,-0.222E-02, 0.734E-03, 0.250E-04, 0.347E-04,
     c 0.814E-03,-0.918E-04,-0.146E-03, 0.283E-03, 0.198E-02,-0.238E-02,
     c 0.741E-04,-0.210E-03,-0.192E-02, 0.106E-02, 0.246E-03, 0.554E-01,
     c-0.402E-03,-0.802E-02, 0.000E+00, 0.470E-04, 0.470E-03, 0.391E-02,
     c 0.175E-02,-0.681E-02, 0.907E-02, 0.385E-03, 0.710E-05, 0.192E-02,
     c 0.311E-03,-0.179E-02,-0.135E-02,-0.120E-02,-0.260E-02,-0.210E-03,
     c 0.751E-02,-0.181E-01, 0.122E-01,-0.337E-02,-0.560E+00, 0.104E-02,
     c 0.163E+00, 0.000E+00, 0.395E-03,-0.957E-02,-0.893E-01, 0.522E-02,
     c 0.164E+00,-0.819E-01,-0.262E-02,-0.285E-02,-0.659E-01, 0.741E-03,
     c 0.282E-01,-0.111E-01, 0.255E-01, 0.329E-01,-0.192E-02,-0.181E-01,
     c 0.253E+00,-0.111E+00, 0.253E-02, 0.240E+00,-0.918E-03,-0.775E-01,
     c 0.000E+00,-0.370E-03, 0.485E-02, 0.445E-01, 0.282E-02,-0.773E-01,
     c 0.490E-01, 0.140E-02, 0.140E-02, 0.309E-01,-0.150E-02,-0.112E-01,
     c 0.487E-02,-0.101E-01,-0.161E-01, 0.106E-02, 0.122E-01,-0.111E+00,
     c 0.674E-01/

      data covd/
     c 0.000E+00, 0.000E+00, 0.000E+00, 0.000E+00, 0.000E+00, 0.000E+00,
     c 0.000E+00, 0.000E+00, 0.000E+00, 0.000E+00, 0.000E+00, 0.000E+00,
     c 0.000E+00, 0.000E+00, 0.000E+00, 0.000E+00, 0.000E+00, 0.000E+00,
     c 0.000E+00, 0.000E+00, 0.000E+00, 0.000E+00, 0.000E+00, 0.000E+00,
     c 0.101E-06,-0.540E-05, 0.000E+00, 0.000E+00, 0.117E-04,-0.936E-05,
     c 0.958E-05,-0.371E-04, 0.371E-04,-0.148E-06, 0.533E-06, 0.820E-06,
     c-0.516E-05, 0.187E-05, 0.851E-05,-0.294E-05, 0.267E-04, 0.589E-05,
     c 0.560E-05, 0.567E-05, 0.487E-03, 0.774E-05, 0.000E+00,-0.540E-05,
     c 0.583E-02, 0.000E+00, 0.000E+00,-0.421E-02, 0.263E-02,-0.472E-02,
     c 0.472E-02,-0.558E-02, 0.179E-04,-0.634E-04,-0.133E-02, 0.135E-02,
     c 0.138E-03, 0.205E-02, 0.363E-02,-0.149E-01, 0.671E-02,-0.236E-02,
     c-0.489E-02,-0.576E-01, 0.600E-03, 0.000E+00, 0.000E+00, 0.000E+00,
     c 0.000E+00, 0.000E+00, 0.000E+00, 0.000E+00, 0.000E+00, 0.000E+00,
     c 0.000E+00, 0.000E+00, 0.000E+00, 0.000E+00, 0.000E+00, 0.000E+00,
     c 0.000E+00, 0.000E+00, 0.000E+00, 0.000E+00, 0.000E+00, 0.000E+00,
     c 0.000E+00, 0.000E+00, 0.000E+00, 0.000E+00, 0.000E+00, 0.000E+00,
     c 0.000E+00, 0.000E+00, 0.000E+00, 0.000E+00, 0.000E+00, 0.000E+00,
     c 0.000E+00, 0.000E+00, 0.000E+00, 0.000E+00, 0.000E+00, 0.000E+00,
     c 0.000E+00, 0.000E+00, 0.000E+00, 0.000E+00, 0.000E+00, 0.000E+00,
     c 0.000E+00, 0.000E+00, 0.117E-04,-0.421E-02, 0.000E+00, 0.000E+00,
     c 0.598E-02,-0.386E-02, 0.511E-02,-0.764E-02, 0.816E-02,-0.620E-04,
     c 0.108E-03, 0.145E-02,-0.345E-02, 0.709E-03, 0.507E-02,-0.275E-02,
     c 0.166E-01, 0.360E-02, 0.313E-02, 0.413E-02, 0.281E+00, 0.374E-02,
     c 0.000E+00,-0.936E-05, 0.263E-02, 0.000E+00, 0.000E+00,-0.386E-02,
     c 0.417E-02,-0.176E-02, 0.544E-02,-0.441E-02, 0.601E-04,-0.768E-04,
     c 0.117E-02, 0.326E-02,-0.278E-03, 0.137E-02, 0.226E-02,-0.101E-01,
     c 0.153E-02,-0.186E-02,-0.212E-02,-0.140E+00,-0.128E-02, 0.000E+00,
     c 0.958E-05,-0.472E-02, 0.000E+00, 0.000E+00, 0.511E-02,-0.176E-02,
     c 0.874E-02,-0.583E-02, 0.829E-02, 0.231E-04, 0.892E-04, 0.359E-02,
     c 0.129E-02,-0.259E-04, 0.813E-02,-0.761E-03, 0.710E-02, 0.564E-02,
     c 0.116E-02, 0.344E-02, 0.154E+00, 0.226E-02, 0.000E+00,-0.371E-04,
     c 0.472E-02, 0.000E+00, 0.000E+00,-0.764E-02, 0.544E-02,-0.583E-02,
     c 0.421E+00,-0.421E+00, 0.742E-03,-0.230E-03,-0.122E-02, 0.468E-02,
     c-0.144E-02,-0.675E-02, 0.311E-02,-0.277E-01,-0.799E-02,-0.679E-02,
     c-0.570E-02,-0.438E+00,-0.747E-02, 0.000E+00, 0.371E-04,-0.558E-02,
     c 0.000E+00, 0.000E+00, 0.816E-02,-0.441E-02, 0.829E-02,-0.421E+00,
     c 0.422E+00,-0.692E-03, 0.236E-03, 0.325E-02,-0.327E-02, 0.143E-02,
     c 0.112E-01,-0.273E-02, 0.270E-01, 0.685E-02, 0.576E-02, 0.651E-02,
     c 0.459E+00, 0.765E-02, 0.000E+00,-0.148E-06, 0.179E-04, 0.000E+00,
     c 0.000E+00,-0.620E-04, 0.601E-04, 0.231E-04, 0.742E-03,-0.692E-03,
     c 0.391E-05,-0.127E-05, 0.187E-04, 0.112E-03,-0.217E-04, 0.713E-05,
     c 0.549E-04,-0.354E-03,-0.159E-03,-0.106E-03,-0.446E-04,-0.509E-02,
     c-0.915E-04, 0.000E+00, 0.533E-06,-0.634E-04, 0.000E+00, 0.000E+00,
     c 0.108E-03,-0.768E-04, 0.892E-04,-0.230E-03, 0.236E-03,-0.127E-05,
     c 0.328E-05, 0.183E-04,-0.583E-04, 0.161E-04, 0.903E-04,-0.399E-04,
     c 0.286E-03, 0.645E-04, 0.572E-04, 0.663E-04, 0.504E-02, 0.740E-04,
     c 0.000E+00, 0.820E-06,-0.133E-02, 0.000E+00, 0.000E+00, 0.145E-02,
     c 0.117E-02, 0.359E-02,-0.122E-02, 0.325E-02, 0.187E-04, 0.183E-04,
     c 0.321E-02, 0.997E-03, 0.255E-03, 0.772E-02, 0.195E-03, 0.361E-02,
     c 0.612E-02, 0.734E-03, 0.159E-02, 0.112E+00, 0.233E-02, 0.000E+00,
     c-0.516E-05, 0.135E-02, 0.000E+00, 0.000E+00,-0.345E-02, 0.326E-02,
     c 0.129E-02, 0.468E-02,-0.327E-02, 0.112E-03,-0.583E-04, 0.997E-03,
     c 0.640E-02,-0.123E-02, 0.271E-03, 0.340E-02,-0.185E-01, 0.461E-04,
     c-0.367E-02,-0.297E-02,-0.271E+00,-0.350E-02, 0.000E+00, 0.187E-05,
     c 0.138E-03, 0.000E+00, 0.000E+00, 0.709E-03,-0.278E-03,-0.259E-04,
     c-0.144E-02, 0.143E-02,-0.217E-04, 0.161E-04, 0.255E-03,-0.123E-02,
     c 0.562E-03, 0.221E-02,-0.256E-03, 0.513E-02, 0.221E-02, 0.126E-02,
     c 0.836E-03, 0.109E+00, 0.213E-02, 0.000E+00, 0.851E-05, 0.205E-02,
     c 0.000E+00, 0.000E+00, 0.507E-02, 0.137E-02, 0.813E-02,-0.675E-02,
     c 0.112E-01, 0.713E-05, 0.903E-04, 0.772E-02, 0.271E-03, 0.221E-02,
     c 0.530E-01, 0.706E-02, 0.347E-02, 0.543E-01, 0.256E-02, 0.283E-03,
     c 0.101E+01, 0.178E-01, 0.000E+00,-0.294E-05, 0.363E-02, 0.000E+00,
     c 0.000E+00,-0.275E-02, 0.226E-02,-0.761E-03, 0.311E-02,-0.273E-02,
     c 0.549E-04,-0.399E-04, 0.195E-03, 0.340E-02,-0.256E-03, 0.706E-02,
     c 0.426E-02,-0.150E-01, 0.989E-02,-0.224E-02,-0.383E-02,-0.217E-01,
     c 0.116E-02, 0.000E+00, 0.267E-04,-0.149E-01, 0.000E+00, 0.000E+00,
     c 0.166E-01,-0.101E-01, 0.710E-02,-0.277E-01, 0.270E-01,-0.354E-03,
     c 0.286E-03, 0.361E-02,-0.185E-01, 0.513E-02, 0.347E-02,-0.150E-01,
     c 0.111E+00, 0.500E-03, 0.267E-01, 0.230E-01, 0.118E+01, 0.222E-01,
     c 0.000E+00, 0.589E-05, 0.671E-02, 0.000E+00, 0.000E+00, 0.360E-02,
     c 0.153E-02, 0.564E-02,-0.799E-02, 0.685E-02,-0.159E-03, 0.645E-04,
     c 0.612E-02, 0.461E-04, 0.221E-02, 0.543E-01, 0.989E-02, 0.500E-03,
     c 0.118E+00, 0.114E-01,-0.479E-02, 0.137E+01, 0.321E-01, 0.000E+00,
     c 0.560E-05,-0.236E-02, 0.000E+00, 0.000E+00, 0.313E-02,-0.186E-02,
     c 0.116E-02,-0.679E-02, 0.576E-02,-0.106E-03, 0.572E-04, 0.734E-03,
     c-0.367E-02, 0.126E-02, 0.256E-02,-0.224E-02, 0.267E-01, 0.114E-01,
     c 0.874E-02, 0.449E-02, 0.345E+00, 0.880E-02, 0.000E+00, 0.567E-05,
     c-0.489E-02, 0.000E+00, 0.000E+00, 0.413E-02,-0.212E-02, 0.344E-02,
     c-0.570E-02, 0.651E-02,-0.446E-04, 0.663E-04, 0.159E-02,-0.297E-02,
     c 0.836E-03, 0.283E-03,-0.383E-02, 0.230E-01,-0.479E-02, 0.449E-02,
     c 0.613E-02, 0.197E+00, 0.256E-02, 0.000E+00, 0.487E-03,-0.576E-01,
     c 0.000E+00, 0.000E+00, 0.281E+00,-0.140E+00, 0.154E+00,-0.438E+00,
     c 0.459E+00,-0.509E-02, 0.504E-02, 0.112E+00,-0.271E+00, 0.109E+00,
     c 0.101E+01,-0.217E-01, 0.118E+01, 0.137E+01, 0.345E+00, 0.197E+00,
     c 0.383E+02, 0.727E+00, 0.000E+00, 0.774E-05, 0.600E-03, 0.000E+00,
     c 0.000E+00, 0.374E-02,-0.128E-02, 0.226E-02,-0.747E-02, 0.765E-02,
     c-0.915E-04, 0.740E-04, 0.233E-02,-0.350E-02, 0.213E-02, 0.178E-01,
     c 0.116E-02, 0.222E-01, 0.321E-01, 0.880E-02, 0.256E-02, 0.727E+00,
     c 0.185E-01/

      if (target.eq.'p') then
         do i=1,23
            do j=1,23
               cov(i,j)=covp(i,j)
            enddo
         enddo
      elseif (target.eq.'d') then
         do i=1,23
            do j=1,23
               cov(i,j)=covd(i,j)
            enddo
         enddo         
      endif
      
      return
      end
