# gnuplot file

set term pdfcairo enhanced lw 1.5 size 8cm,7cm
set output 'R-low-Q2-v-W2.pdf'
set sty dat lines

set bars small
mpsq=0.938**2
W2(x,Q2)=mpsq+Q2*(1-x)/x

set xrange [1.15:4]
set yrange [0:0.8]

set key spacing 1.34

gen=' --gen-x-at-Q2 1.75 --nx 300 --xmin 0.01 --xmax 0.9 '

set ylabel 'R_{L/T}'
set xlabel 'W^2 [GeV^2]'

set label 1 'Q^2 = 1.75 GeV^2' at graph 0.05,0.92 tc rgb '#808080'

#set key box

set lt  1 lw 2 lc rgb '#003030e0'
set lt 11 lw 2 lc rgb '#803030e0'
set lt  2 lw 2 lc rgb '#00ff0000'
set lt  9 lw 1 lc rgb 'black'

plot '../validation-files-LUXqed17/inel-param-Hermes_ALLM_CLAS-Q2-1.75.dat' u (W2($1,$2)):($6*0.5):($6*1.5) w filledcurves lt 11 t 'R_{1998} ± 50\%',\
     ''                                                                     u (W2($1,$2)):6 lt 1 t 'R_{1998}',\
     '../validation-files-LUXqed17/inel-param-Christy_Bosted-Q2-1.75.dat'   u (W2($1,$2)):6 lt 2 t 'R_{Christy-Bosted}',\
     '../data/nucl-ex-0410027v2-Q2-1.75.dat' u 1:2:($4-$2) w error pt 7 ps 0.5 lc rgb 'black' t 'E94-110'
     

set output

