# gnuplot file

set macros
set term pdfcairo size 8cm,6cm lw 1.5
set output 'elastic-component.pdf'

load './xaxis.gp'

fc1="w filledcurves fc rgb '#808080' fs border lc rgb '#000000'"
lc1="w l lc rgb '#000000'"
fc2="w filledcurves fc rgb '#80f08000' fs border lc rgb '#ff0000'"
lc2="w l lc rgb '#ff0000'"

fc3="w filledcurves fc rgb '#b00000f0' fs border lc rgb '#0000f0'"
lc3="w l dt 2 lc rgb '#0000f0'"

fc4="w filledcurves fc rgb '#b000ff00' fs border lc rgb '#00a000'"
lc4="w l lc rgb '#00a000'"

# each file has 6 columns. We are interested in columns 1 & 3
m='<./mergeidx.pl '
c=' Columns'
A1world=' -f A1_world_spline.dat -f A1_world_spline_up_err.dat -f A1_world_spline_down_err.dat -f dipole.dat'
A1worlP=' -f A1_world_pol_spline.dat -f A1_world_pol_spline_up_err.dat -f A1_world_pol_spline_down_err.dat -f dipole.dat'

set key bottom left Left reverse spacing 1.5

set grid

set yrange [0.85:1.24]
set ylabel 'ratio to dipole elastic component'
# 6 columns per file
# 3 is central
plot m.A1world.c u (zeta_of_x($1)):($9/$21):($15/$21) @fc2 t 'A1 world',\
     m.A1worlP.c u (zeta_of_x($1)):($9/$21):($15/$21) @fc4 t 'A1 world pol',\
     m.A1world.c u (zeta_of_x($1)):($3/$21) @lc2 t '',\
     m.A1worlP.c u (zeta_of_x($1)):($3/$21) @lc4 t '',\
     1       @lc1 t 'dipole'

A1world=' -f A1_world_spline.dat -f A1_world_spline_up_err.dat -f A1_world_spline_down_err.dat -f A1_world_pol_spline.dat '
A1worlP=' -f A1_world_pol_spline.dat -f A1_world_pol_spline_up_err.dat -f A1_world_pol_spline_down_err.dat -f A1_world_pol_spline.dat'
dipole=' -f dipole.dat  -f A1_world_pol_spline.dat'

set yrange [0.75:1.05]
set ylabel 'ratio of f_{/Symbol g}^{el} to its A1 world pol. value ' 
plot m.A1world.c u (zeta_of_x($1)):($9/$21):($15/$21) @fc2 t 'A1 world',\
     m.A1worlP.c u (zeta_of_x($1)):($9/$21):($15/$21) @fc4 t 'A1 world pol',\
     m.A1world.c u (zeta_of_x($1)):($3/$21) @lc2 t '',\
     m.A1worlP.c u (zeta_of_x($1)):($3/$21) @lc4 t '',\
     m.dipole.c  u (zeta_of_x($1)):($3/$9) @lc1 t 'dipole'

set yrange [0.965:1.025]
set format y "%5.3f"
set ytics 0.005
replot

set output
