# gnuplot file

set macros
set term pdfcairo size 7.5cm,6.5cm
set output 'elastic-FF-paper-electric.pdf'

#set label 1 'results from 1307.6227' at graph 0.05,0.95

dipole(Q2)=1.0/(1.0 + Q2/0.71)**2
mum_proton = 2.792847356

dataWorld="data/1307-6227-aux/fits/World/CrossSectionsOnly/SplinesWithVariableKnots.dat"
dataWorlP="data/1307-6227-aux/fits/World/CrossSectionsAndPolarized/SplinesWithVariableKnots.dat"
#dataMainz="data/1307-6227-aux/fits/MainzOnly/SplineMultipliedWithStandardDipole.dat"
dataMainz="data/1307-6227-aux/fits/MainzOnly/Spline.dat"
ourInterp='<paste elastic-FF-A1-world.dat elastic-FF-A1-world-up.dat elastic-FF-A1-world-down.dat'
dataHill="data/Hill-Lee-FormFactors/calcFF/output/output-world.dat"
dataHillV="<mergeidx.pl -f elastic-FF-Hill-validation.dat -f elastic-FF-dnerr-Hill-validation.dat -f elastic-FF-uperr-Hill-validation.dat format"

#set xrange [1e-4:100]
#set log x
#xsset format x "10^{%T}"




resc(Q2,y)=(y/dipole(Q2))

set key left Left reverse bottom spacing 1.5 width -3 box opaque

set grid front


fc1="w filledcurves fc rgb '#808080' fs border lc rgb '#000000'"
lc1="w l lc rgb '#000000'"
fc2="w filledcurves fc rgb '#80f08000' fs border lc rgb '#ff0000'"
lc2="w l lc rgb '#ff0000'"
lc3="w l dt 2 lc rgb '#0000f0'"
fc4="w filledcurves fc rgb '#b000ff00' fs border lc rgb '#00a000'"
lc4="w l lc rgb '#00a000'"
lc5="w l dt 2 lc rgb '#00ffff'"

set key opaque 

xmap(x)=x<1?x:1+(x-1)/10.0
set xlabel 'Q^2 [GeV^2]'
set xrange [xmap(0):xmap(5.0)]
set xtics ()
do for [i=0:5] {set xtics add (sprintf("%g",i*0.2) xmap(i*0.2))}
do for [i=2:10] {set xtics add (sprintf("%d",i) xmap(i*1))}


ylo=0.5
yhi=1.2
set yrange [resc(0,ylo):resc(0,yhi)]
set mytics 5

#set arrow from xmap(1.0),resc(0,ylo) to xmap(1.0),resc(0,yhi) nohead lw 2 lc rgb '#000000' back
xl=0.994
xm=1.00
xh=1.10
set arrow from xmap(xl),resc(0,ylo) to xmap(xl),resc(0,yhi) nohead lw 2 lc rgb '#000000' front
set arrow from xmap(xh),resc(0,ylo) to xmap(xh),resc(0,yhi) nohead lw 2 lc rgb '#000000' front
set arrow from xmap(xm),resc(0,ylo-0.01) to xmap(xm),resc(0,yhi+0.01) nohead lw 2 lc rgb '#ffffff' front


set ylabel 'G_{/*0.8 E}(Q^2) / G_@{/*0.8 E}^{dip}(Q^2)' offset 1
resM(Q2,y)=resc(Q2,y)/2.792847356


set output 'elastic-FF-paper-electric.pdf'

plot      1 @lc3  t '',\
     dataWorld u (xmap($1)):(resc($1,$2+sqrt($3**2+$4**2))):(resc($1,$2-sqrt($3**2+$5**2))) @fc2 t 'A1 fit (no pol.)',\
     dataWorlP u (xmap($1)):(resc($1,$2+sqrt($3**2+$4**2))):(resc($1,$2-sqrt($3**2+$5**2))) @fc4 t 'A1 fit (with pol.)',\
     dataWorld u (xmap($1)):(resc($1,$2)) @lc2 t '',\
     dataWorlP u (xmap($1)):(resc($1,$2)) @lc4 t ''


set output 'elastic-FF-paper-electric-with-Hill.pdf'
     
plot      1 @lc3  t '',\
     dataHill  u (xmap($1)):(resc($1,$3+$4)):(resc($1,$3-$4)) @fc1 t 'Lee-Arrington-Hill',\
     dataWorld u (xmap($1)):(resc($1,$2+sqrt($3**2+$4**2))):(resc($1,$2-sqrt($3**2+$5**2))) @fc2 t 'A1 fit (no pol.)',\
     dataWorlP u (xmap($1)):(resc($1,$2+sqrt($3**2+$4**2))):(resc($1,$2-sqrt($3**2+$5**2))) @fc4 t 'A1 fit (with pol.)',\
     dataHill  u (xmap($1)):(resc($1,$3)) @lc1 t '',\
     dataWorld u (xmap($1)):(resc($1,$2)) @lc2 t '',\
     dataWorlP u (xmap($1)):(resc($1,$2)) @lc4 t ''


# plot      1 @lc3  t '',\
#      dataHill  u (xmap($1)):(resM($1,$5+$6)):(resM($1,$5-$6)) @fc1 t 'Lee-Arrington-Hill',\
#      dataWorld u (xmap($1)):(resc($1,$6+sqrt($7**2+$8**2))):(resc($1,$6-sqrt($7**2+$9**2))) @fc2 t 'A1 fit (no pol.)',\
#      dataWorlP u (xmap($1)):(resc($1,$6+sqrt($7**2+$8**2))):(resc($1,$6-sqrt($7**2+$9**2))) @fc4 t 'A1 fit (with pol.)',\
#      dataHill  u (xmap($1)):(resM($1,$5)) @lc1 t '',\
#      dataWorld u (xmap($1)):(resc($1,$6)) @lc2 t '',\
#      dataWorlP u (xmap($1)):(resc($1,$6)) @lc4 t ''
# 
# set output
exit

# set multiplot title 'Magnetic FF / ({/Symbol m}_p dipole)'
# resM(Q2,y)=resc(Q2,y)/2.792847356
# set origin 0.5,0
# set size 0.55,0.95
# set xrange [1.02:10]
# set yrange [resc(0,0.8):resc(0,1.15)]
# unset ylabel
# set xlabel '&{Q^2}'
# set format y ""
# set y2tics
# set y2label ""
# unset ytics
# set border 13
# unset key
# set grid y2tics
# set xtics 2
# 
# plot      1 @lc3  t '',\
#      dataHill  u 1:(resM($1,$5+$6)):(resM($1,$5-$6)) @fc1 t 'Lee-Arrington-Hill',\
#      dataWorld u 1:(resc($1,$6+sqrt($7**2+$8**2))):(resc($1,$6-sqrt($7**2+$9**2))) @fc2 t 'A1 fit (no pol.) ',\
#      dataWorlP u 1:(resc($1,$6+sqrt($7**2+$8**2))):(resc($1,$6-sqrt($7**2+$9**2))) @fc4 t 'A1 fit (with pol.)',\
#      dataHill  u 1:(resM($1,$5)) @lc1 t '',\
#      dataWorld u 1:(resc($1,$6)) @lc2 t '',\
#      dataWorlP u 1:(resc($1,$6)) @lc4 t ''
#     
# set xtics 0.2
# set ytics    
# set xlabel 'Q^2 [GeV^2]'
# set xlabel offset 10
# set origin 0.0,0.0
# set size 0.62,0.95
# set yrange [0.8:1.15]
# set xrange [0:1]
# unset y2tics
# unset mytics
# set border 7
# set format y '%g'
# set ylabel 'G_{/*0.8 M}(Q^2) / G_@{/*0.8 M}^{dip}(Q^2)'
# set key opaque
# replot
# unset multiplot



set output
