# gnuplot file

set term pdfcairo lw 1.5 enhanced size 8cm,7cm
set output 'flav-thresholds.pdf'
set  style data lines

pdfFullNames="CT14nnlo MMHT2014nnlo68cl NNPDF30_nnlo_as_0118 PDF4LHC15_nnlo_100"
pdfShortNames="CT14nnlo MMHT2014nnlo68cl NNPDF30 PDF4LHC15"
pdfDisplayNames="CT14nnlo MMHT2014nnlo68cl NNPDF30\\_nnlo\\_as\\_0118 PDF4LHC15\\_nnlo\\_100"

x='0.1'

set lt 1 lw 1.5 lc rgb '#f00000'
set lt 2 lw 1.5 lc rgb '#4040f0'
set lt 3 lw 1.5 lc rgb '#00b000'
set lt 4 lw 3 lc rgb '#000000'


set xrange [:6.5]
set xtics 1
set mxtics 5
set ytics 2; set mytics 2
set key left Left reverse spacing 1.35

set xlabel 'μ [GeV]'
set ylabel 'x f_{b/p}(x, μ^2)・10^3'
set yrange [-0.5:]

set title 'b-quark PDF μ-dependence at x = '.x
#set label 1 'x = '.x at graph 0.95,0.05 right 

plot for [i=1:4] 'x'.x.'-'.word(pdfFullNames,i) u 2:($3*1000) t word(pdfDisplayNames,i)

set title 'up-quark PDF μ-dependence at x = '.x
set key right Right noreverse bottom
set ylabel 'x f_{u/p}(x, μ^2)'
set xrange [1:2.0]
set xtics 0.2
set auto y
set ytics auto
plot for [i=1:4] 'x'.x.'-up-'.word(pdfFullNames,i) u 2:($3) t word(pdfDisplayNames,i)


set output