# gnuplot file, template generated automatically with
# /Users/gsalam/scripts/gptemplate.py lumis.gp

set term pdfcairo enhanced font 'Helvetica,12' lw 1.5 size 8cm,7cm
set lt 1 pt 4 ps 0.6 lw 1.5 lc rgb '#f00000'
set lt 2 pt 5 ps 0.6 lw 1.5 lc rgb '#00c000'
set lt 3 pt 6 ps 0.6 lw 1.5 lc rgb '#0000e0'
set lt 4 pt 7 ps 0.6 lw 1.5 lc rgb '#ff8000'
set lt 5 pt 8 ps 0.6 lw 1.5 lc rgb '#5070ff'
set lt 11 pt 4 ps 0.6 lw 1.5 lc rgb '#50f00000'
set lt 12 pt 5 ps 0.6 lw 1.5 lc rgb '#5000c000'
set lt 13 pt 6 ps 0.6 lw 1.5 lc rgb '#500000e0'
set lt 14 pt 7 ps 0.6 lw 1.5 lc rgb '#50ff8000'
set lt 15 pt 8 ps 0.6 lw 1.5 lc rgb '#505070ff'
set key spacing 1.3 width -4
set macros
set output 'mom-LUX17.pdf'


pdf='LUXqed17_plus_PDF4LHC15_nnlo_100'
pdfdisplay='{/*0.7 LUXqed17\_plus\_PDF4LHC15\_nnlo\_100}'
file="mom-photon-LUXqed17_plus_PDF4LHC15_nnlo_100.dat"

band   ='u ($1):($2-$3):($2+$3)'
line   ='u ($1):($2)'
relband='u ($1):(($2-$3)/$2-1):(($2+$3)/$2-1)'
relline='u ($1):(0)'
rellnhi='u ($1):(($2+$3)/$2-1)'
rellnlo='u ($1):(($2-$3)/$2-1)'

set grid lt 1 lc rgb '#e0000000' lw 0.5

set origin 0,0
set size 1,1
set yrange [0:0.008]
set log x

set ylabel 'γ momentum fraction' offset 0

set xlabel 'μ [GeV]'
#set xtics add (0.2, 0.5, 2, 5, 20, 50)
#set format y '10^{%T}'
#set ytics 10
#set ytics add ('0.1' 0.1, '1' 1, '10' 10)

set lmargin at screen 0.23

set xrange [10:1e4]
set label 2 pdfdisplay at graph 0.06,0.19
plot file @band w filledcurves lt 11 t '', '' @line w l lt 1 t ''
     
set multiplot
#---- first panel of multiplot
set ytics 0.001
set ytics add ("" 0.001, "" 0.003, "" 0.005, "" 0.007)
set mytics 5
set origin 0.0,0.5; set size 1.0,0.5
set bmargin 0
set xtics tc rgb '#ff000000'
set xlabel tc rgb '#ff000000'
replot

# now the relative bands
set bmargin -1
set origin 0.0,0.0; set size 1.0,0.5
set format y '%g'
unset log y
set ytics 0.01
set mytics 2
set xtics  tc rgb '#00000000'
set xlabel tc rgb '#00000000'
set ylabel 'rel. uncertainty' offset -1.0
unset label 1
unset label 2
set yrange [-0.02:0.02]
plot file @relband w filledcurves lt 11 t '', '' @relline w l lt 1 t '',\
     file @rellnhi w l lt 11 lw 1.0     t '', '' @rellnlo w l lt 11 lw 1.0 t '',\

     
unset multiplot     

#}
set output

